/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.syncano.library.api.Response;
import com.syncano.library.api.ResponseGetList;
import com.syncano.library.callbacks.SyncanoCallback;
import com.syncano.library.choice.Case;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.simple.RequestBuilder;
import com.syncano.library.utils.DateTool;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Where<T extends SyncanoObject> {
    public static final String FILTER_GT = "_gt";
    public static final String FILTER_GTE = "_gte";
    public static final String FILTER_LT = "_lt";
    public static final String FILTER_LTE = "_lte";
    public static final String FILTER_EQ = "_eq";
    public static final String FILTER_INS_EQ = "_ieq";
    public static final String FILTER_NEQ = "_neq";
    public static final String FILTER_EXISTS = "_exists";
    public static final String FILTER_IN = "_in";
    public static final String FILTER_IS = "_is";
    public static final String FILTER_START_WITH = "_startswith";
    public static final String FILTER_INS_START_WITH = "_istartswith";
    public static final String FILTER_ENDS_WITH = "_endswith";
    public static final String FILTER_INS_ENDS_WITH = "_iendswith";
    public static final String FILTER_CONTAINS = "_contains";
    public static final String FILTER_INS_CONTAINS = "_icontains";
    private JsonObject query = new JsonObject();
    private RequestBuilder<T> please;

    public Where() {
    }

    public Where(RequestBuilder<T> please) {
        this();
        this.please = please;
    }

    public ResponseGetList<T> get() {
        if (this.please == null) {
            throw new RuntimeException("Can be called only from SyncanoObject.please(class).where().get()");
        }
        return this.please.get();
    }

    @Deprecated
    public ResponseGetList<T> getAll() {
        if (this.please == null) {
            throw new RuntimeException("Can be called only from SyncanoObject.please(class).where().get()");
        }
        return this.please.getAll();
    }

    @Deprecated
    public void getAll(SyncanoCallback<List<T>> callback) {
        if (this.please == null) {
            throw new RuntimeException("Can be called only from SyncanoObject.please(class).where().get()");
        }
        this.please.getAll(callback);
    }

    public void get(SyncanoCallback<List<T>> callback) {
        if (this.please == null) {
            throw new RuntimeException("Can be called only from SyncanoObject.please(class).where().get()");
        }
        this.please.get(callback);
    }

    public Response<String> getWithTemplate(String templateName) {
        if (this.please == null) {
            throw new RuntimeException("Can be called only from SyncanoObject.please(class).where().get()");
        }
        return this.please.getWithTemplate(templateName);
    }

    public void getWithTemplate(String templateName, SyncanoCallback<String> callback) {
        if (this.please == null) {
            throw new RuntimeException("Can be called only from SyncanoObject.please(class).where().get()");
        }
        this.please.getWithTemplate(templateName, callback);
    }

    public Where<T> gt(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_GT, value);
        return this;
    }

    public Where<T> gt(String fieldName, String innerFieldName, Number value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_GT, value);
        return this;
    }

    public Where<T> gt(String fieldName, String value) {
        this.addFilter(fieldName, FILTER_GT, value);
        return this;
    }

    public Where<T> gt(String fieldName, String innerFieldName, String value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_GT, value);
        return this;
    }

    public Where<T> gt(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_GT, value);
        return this;
    }

    public Where<T> gt(String fieldName, String innerFieldName, Date value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_GT, value);
        return this;
    }

    public Where<T> gte(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_GTE, value);
        return this;
    }

    public Where<T> gte(String fieldName, String innerFieldName, Number value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_GTE, value);
        return this;
    }

    public Where<T> gte(String fieldName, String value) {
        this.addFilter(fieldName, FILTER_GTE, value);
        return this;
    }

    public Where<T> gte(String fieldName, String innerFieldName, String value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_GTE, value);
        return this;
    }

    public Where<T> gte(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_GTE, value);
        return this;
    }

    public Where<T> gte(String fieldName, String innerFieldName, Date value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_GTE, value);
        return this;
    }

    public Where<T> lt(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_LT, value);
        return this;
    }

    public Where<T> lt(String fieldName, String innerFieldName, Number value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_LT, value);
        return this;
    }

    public Where<T> lt(String fieldName, String value) {
        this.addFilter(fieldName, FILTER_LT, value);
        return this;
    }

    public Where<T> lt(String fieldName, String innerFieldName, String value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_LT, value);
        return this;
    }

    public Where<T> lt(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_LT, value);
        return this;
    }

    public Where<T> lt(String fieldName, String innerFieldName, Date value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_LT, value);
        return this;
    }

    public Where<T> lte(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_LTE, value);
        return this;
    }

    public Where<T> lte(String fieldName, String innerFieldName, Number value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_LTE, value);
        return this;
    }

    public Where<T> lte(String fieldName, String value) {
        this.addFilter(fieldName, FILTER_LTE, value);
        return this;
    }

    public Where<T> lte(String fieldName, String innerFieldName, String value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_LTE, value);
        return this;
    }

    public Where<T> lte(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_LTE, value);
        return this;
    }

    public Where<T> lte(String fieldName, String innerFieldName, Date value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_LTE, value);
        return this;
    }

    public Where<T> eq(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_EQ, value);
        return this;
    }

    public Where<T> eq(String fieldName, String innerFieldName, Number value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_EQ, value);
        return this;
    }

    public Where<T> eq(String fieldName, Boolean value) {
        this.addFilter(fieldName, FILTER_EQ, value);
        return this;
    }

    public Where<T> eq(String fieldName, String innerFieldName, Boolean value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_EQ, value);
        return this;
    }

    public Where<T> eq(String fieldName, String value) {
        return this.eq(fieldName, value, Case.SENSITIVE);
    }

    public Where<T> eq(String fieldName, String innerFieldName, String value) {
        return this.eq(fieldName, innerFieldName, value, Case.SENSITIVE);
    }

    public Where<T> eq(String fieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_EQ : FILTER_INS_EQ;
        this.addFilter(fieldName, filterName, value);
        return this;
    }

    public Where<T> eq(String fieldName, String innerFieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_EQ : FILTER_INS_EQ;
        this.addInnerFilter(fieldName, innerFieldName, filterName, value);
        return this;
    }

    public Where<T> eq(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_EQ, value);
        return this;
    }

    public Where<T> eq(String fieldName, String innerFieldName, Date value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_EQ, value);
        return this;
    }

    public Where<T> neq(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_NEQ, value);
        return this;
    }

    public Where<T> neq(String fieldName, String innerFieldName, Number value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_NEQ, value);
        return this;
    }

    public Where<T> neq(String fieldName, Boolean value) {
        this.addFilter(fieldName, FILTER_NEQ, value);
        return this;
    }

    public Where<T> neq(String fieldName, String innerFieldName, Boolean value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_NEQ, value);
        return this;
    }

    public Where neq(String fieldName, String value) {
        this.addFilter(fieldName, FILTER_NEQ, value);
        return this;
    }

    public Where neq(String fieldName, String innerFieldName, String value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_NEQ, value);
        return this;
    }

    public Where<T> neq(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_NEQ, value);
        return this;
    }

    public Where<T> neq(String fieldName, String innerFieldName, Date value) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_NEQ, value);
        return this;
    }

    public Where<T> startsWith(String fieldName, String value) {
        return this.startsWith(fieldName, value, Case.SENSITIVE);
    }

    public Where<T> startsWith(String fieldName, String innerFieldName, String value) {
        return this.startsWith(fieldName, innerFieldName, value, Case.SENSITIVE);
    }

    public Where<T> startsWith(String fieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_START_WITH : FILTER_INS_START_WITH;
        this.addFilter(fieldName, filterName, value);
        return this;
    }

    public Where<T> startsWith(String fieldName, String innerFieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_START_WITH : FILTER_INS_START_WITH;
        this.addInnerFilter(fieldName, innerFieldName, filterName, value);
        return this;
    }

    public Where<T> endsWith(String fieldName, String value) {
        return this.endsWith(fieldName, value, Case.SENSITIVE);
    }

    public Where<T> endsWith(String fieldName, String innerFieldName, String value) {
        return this.endsWith(fieldName, innerFieldName, value, Case.SENSITIVE);
    }

    public Where<T> endsWith(String fieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_ENDS_WITH : FILTER_INS_ENDS_WITH;
        this.addFilter(fieldName, filterName, value);
        return this;
    }

    public Where<T> endsWith(String fieldName, String innerFieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_ENDS_WITH : FILTER_INS_ENDS_WITH;
        this.addInnerFilter(fieldName, innerFieldName, filterName, value);
        return this;
    }

    public Where<T> contains(String fieldName, String value) {
        return this.contains(fieldName, value, Case.SENSITIVE);
    }

    public Where<T> contains(String fieldName, String innerFieldName, String value) {
        return this.contains(fieldName, innerFieldName, value, Case.SENSITIVE);
    }

    public Where<T> contains(String fieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_CONTAINS : FILTER_INS_CONTAINS;
        this.addFilter(fieldName, filterName, value);
        return this;
    }

    public Where<T> contains(String fieldName, String innerFieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_CONTAINS : FILTER_INS_CONTAINS;
        this.addInnerFilter(fieldName, innerFieldName, filterName, value);
        return this;
    }

    public Where<T> isNotNull(String fieldName) {
        this.addFilter(fieldName, FILTER_EXISTS, true);
        return this;
    }

    public Where<T> isNull(String fieldName) {
        this.addFilter(fieldName, FILTER_EXISTS, false);
        return this;
    }

    public Where<T> isNotNull(String fieldName, String innerFieldName) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_EXISTS, true);
        return this;
    }

    public Where<T> isNull(String fieldName, String innerFieldName) {
        this.addInnerFilter(fieldName, innerFieldName, FILTER_EXISTS, false);
        return this;
    }

    public Where<T> in(String fieldName, Number[] values) {
        JsonArray jsonArray = new JsonArray();
        for (Number element : values) {
            jsonArray.add((JsonElement)new JsonPrimitive(element));
        }
        this.addFilter(fieldName, FILTER_IN, (JsonElement)jsonArray);
        return this;
    }

    public Where<T> in(String fieldName, String innerFieldName, Number[] values) {
        JsonArray jsonArray = new JsonArray();
        for (Number element : values) {
            jsonArray.add((JsonElement)new JsonPrimitive(element));
        }
        this.addInnerFilter(fieldName, innerFieldName, FILTER_IN, (JsonElement)jsonArray);
        return this;
    }

    public Where<T> in(String fieldName, String[] values) {
        JsonArray jsonArray = new JsonArray();
        for (String element : values) {
            jsonArray.add((JsonElement)new JsonPrimitive(element));
        }
        this.addFilter(fieldName, FILTER_IN, (JsonElement)jsonArray);
        return this;
    }

    public Where<T> in(String fieldName, String innerFieldName, String[] values) {
        JsonArray jsonArray = new JsonArray();
        for (String element : values) {
            jsonArray.add((JsonElement)new JsonPrimitive(element));
        }
        this.addInnerFilter(fieldName, innerFieldName, FILTER_IN, (JsonElement)jsonArray);
        return this;
    }

    public Where<T> in(String fieldName, Date[] values) {
        JsonArray jsonArray = new JsonArray();
        for (Date element : values) {
            jsonArray.add((JsonElement)new JsonPrimitive(DateTool.parseDate(element)));
        }
        this.addFilter(fieldName, FILTER_IN, (JsonElement)jsonArray);
        return this;
    }

    public Where<T> in(String fieldName, String innerFieldName, Date[] values) {
        JsonArray jsonArray = new JsonArray();
        for (Date element : values) {
            jsonArray.add((JsonElement)new JsonPrimitive(DateTool.parseDate(element)));
        }
        this.addInnerFilter(fieldName, innerFieldName, FILTER_IN, (JsonElement)jsonArray);
        return this;
    }

    private void addInnerFilter(String field, String innerField, String filter, JsonElement value) {
        JsonObject jsonObject = this.createIfNoExist(this.query, field);
        JsonObject innerTreeJsonObject = this.createIfNoExist(jsonObject, FILTER_IS);
        JsonObject jsonInnerFieldObject = this.createIfNoExist(innerTreeJsonObject, innerField);
        jsonInnerFieldObject.add(filter, value);
    }

    private void addFilter(String field, String filter, Number value) {
        this.addFilter(field, filter, (JsonElement)new JsonPrimitive(value));
    }

    private void addInnerFilter(String field, String innerField, String filter, Number value) {
        this.addInnerFilter(field, innerField, filter, (JsonElement)new JsonPrimitive(value));
    }

    private void addFilter(String field, String filter, Boolean value) {
        this.addFilter(field, filter, (JsonElement)new JsonPrimitive(value));
    }

    private void addInnerFilter(String field, String innerField, String filter, Boolean value) {
        this.addInnerFilter(field, innerField, filter, (JsonElement)new JsonPrimitive(value));
    }

    private void addFilter(String field, String filter, String value) {
        this.addFilter(field, filter, (JsonElement)new JsonPrimitive(value));
    }

    private void addInnerFilter(String field, String innerField, String filter, String value) {
        this.addInnerFilter(field, innerField, filter, (JsonElement)new JsonPrimitive(value));
    }

    private void addFilter(String field, String filter, Date date) {
        this.addFilter(field, filter, (JsonElement)new JsonPrimitive(DateTool.parseDate(date)));
    }

    private void addInnerFilter(String field, String innerField, String filter, Date date) {
        this.addInnerFilter(field, innerField, filter, (JsonElement)new JsonPrimitive(DateTool.parseDate(date)));
    }

    private void addFilter(String field, String filter, JsonElement value) {
        JsonObject jsonObject = this.createIfNoExist(this.query, field);
        jsonObject.add(filter, value);
    }

    private JsonObject createIfNoExist(JsonObject jsonObject, String key) {
        JsonObject jsonIsObject = jsonObject.getAsJsonObject(key);
        if (jsonIsObject == null) {
            jsonIsObject = new JsonObject();
            jsonObject.add(key, (JsonElement)jsonIsObject);
        }
        return jsonIsObject;
    }

    private JsonObject createIfNoExist(Map<String, JsonObject> query, String key) {
        JsonObject jsonObject = query.get(key);
        if (jsonObject == null) {
            jsonObject = new JsonObject();
            query.put(key, jsonObject);
        }
        return jsonObject;
    }

    public String buildQuery() {
        return new Gson().toJson((JsonElement)this.query);
    }

    public JsonObject getQueryMap() {
        return this.query;
    }

    public void setQueryMap(JsonObject map) {
        this.query = map;
    }

    public Response<Integer> getCountEstimation() {
        if (this.please == null) {
            throw new RuntimeException("Can be called only from SyncanoObject.please(class).where().get()");
        }
        return this.please.getCountEstimation();
    }
}

