/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syncano.library.Syncano;
import com.syncano.library.annotation.SyncanoField;
import com.syncano.library.api.Request;
import com.syncano.library.api.Response;
import com.syncano.library.api.ResultRequest;
import com.syncano.library.choice.FieldType;
import com.syncano.library.data.SyncanoFile;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.parser.GsonParser;
import com.syncano.library.utils.SyncanoClassHelper;
import com.syncano.library.utils.SyncanoLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;

public abstract class SendRequest<T>
extends ResultRequest<T> {
    private static final String boundary = "*****" + Long.toString(System.currentTimeMillis()) + "*****";
    private static final String twoHyphens = "--";
    private static final String lineEnd = "\r\n";
    private Object data;
    private Gson gson;
    public static final String UTF8 = "UTF-8";
    private Request.RunAfter<T> runAfter;
    private Request.RunAfter<T> clearFieldsRunAfter = new Request.RunAfter<T>(){

        @Override
        public void run(Response<T> response) {
            if (response.isSuccess() && SendRequest.this.data != null && SendRequest.this.data instanceof SyncanoObject) {
                ((SyncanoObject)SendRequest.this.data).resetRequestBuildingFields();
            }
            if (SendRequest.this.runAfter != null) {
                SendRequest.this.runAfter.run(response);
            }
        }
    };

    protected SendRequest(Class<T> resultType, String url, Syncano syncano, Object data) {
        super(resultType, url, syncano);
        this.updateGivenObject(false);
        this.data = data;
        this.gson = data != null ? GsonParser.createGson(data) : GsonParser.createGson(resultType);
        super.setRunAfter(this.clearFieldsRunAfter);
    }

    @Override
    public HttpEntity prepareParams() {
        if (this.data == null) {
            return null;
        }
        if (!(this.data instanceof SyncanoObject)) {
            return this.prepareStringEntity();
        }
        InputStreamEntity synObjEntity = null;
        try {
            synObjEntity = this.prepareSyncanoObjectEntity();
        }
        catch (IOException | IllegalAccessException e) {
            e.printStackTrace();
        }
        return synObjEntity;
    }

    protected InputStreamEntity prepareSyncanoObjectEntity() throws IOException, IllegalAccessException {
        if (this.data == null) {
            return null;
        }
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        inputStreams.add(this.getStringFieldsInputStream());
        inputStreams.addAll(this.getFileInputStreams());
        inputStreams.add(this.getEndInputStream());
        SequenceInputStream sequenceInputStream = new SequenceInputStream(Collections.enumeration(inputStreams));
        return new InputStreamEntity((InputStream)sequenceInputStream, -1L);
    }

    private ArrayList<InputStream> getFileInputStreams() throws IllegalAccessException, IOException {
        ArrayList<InputStream> streamsList = new ArrayList<InputStream>();
        for (Field field : this.data.getClass().getDeclaredFields()) {
            String fileName;
            FieldType type;
            SyncanoField fieldAnnotation = field.getAnnotation(SyncanoField.class);
            if (fieldAnnotation == null || (type = SyncanoClassHelper.findType(field)) == null || !FieldType.FILE.equals((Object)type)) continue;
            field.setAccessible(true);
            SyncanoFile synFile = (SyncanoFile)field.get(this.data);
            if (synFile == null) continue;
            String fieldName = SyncanoClassHelper.getFieldName(field);
            File file = synFile.getFile();
            byte[] byteData = synFile.getData();
            if (byteData != null) {
                fileName = fieldName;
            } else {
                if (file == null) continue;
                fileName = file.getName();
            }
            streamsList.add(this.getItemStartInputStream(fieldName, fileName));
            if (byteData != null) {
                streamsList.add(new ByteArrayInputStream(byteData));
            } else {
                streamsList.add(new FileInputStream(file));
            }
            streamsList.add(new ByteArrayInputStream(lineEnd.getBytes(UTF8)));
        }
        return streamsList;
    }

    private InputStream getStringFieldsInputStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JsonObject json = this.gson.toJsonTree(this.data).getAsJsonObject();
        ((SyncanoObject)this.data).getIncrementBuilder().build(json);
        for (Map.Entry entry : json.entrySet()) {
            baos.write((twoHyphens + boundary + lineEnd).getBytes(UTF8));
            baos.write(("Content-Disposition: form-data; name=\"" + (String)entry.getKey() + "\"" + lineEnd).getBytes(UTF8));
            baos.write("Content-Type: text/plain\r\n".getBytes(UTF8));
            baos.write(lineEnd.getBytes(UTF8));
            baos.write(GsonParser.getJsonElementAsString((JsonElement)entry.getValue()).getBytes(UTF8));
            baos.write(lineEnd.getBytes(UTF8));
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private InputStream getItemStartInputStream(String name, String filename) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeBytes(twoHyphens + boundary + lineEnd);
        os.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + filename + "\"" + lineEnd);
        os.writeBytes("Content-Type: application/octet-stream\r\n");
        os.writeBytes(lineEnd);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private InputStream getEndInputStream() throws UnsupportedEncodingException {
        return new ByteArrayInputStream((twoHyphens + boundary + twoHyphens + lineEnd).getBytes(UTF8));
    }

    protected StringEntity prepareStringEntity() {
        String text = this.gson.toJson(this.data);
        try {
            return new StringEntity(text, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JsonElement prepareJsonParams() {
        if (this.data == null) {
            return null;
        }
        return this.gson.toJsonTree(this.data);
    }

    @Override
    public String getContentType() {
        if (this.data == null || !(this.data instanceof SyncanoObject)) {
            return "application/json";
        }
        return "multipart/form-data; boundary=" + boundary;
    }

    @Override
    public T parseResult(Response<T> response, String json) {
        if (this.isSetUpdateGivenObject()) {
            if (this.data.getClass().isAssignableFrom(this.resultType)) {
                return (T)GsonParser.createGson(this.data).fromJson(json, this.resultType);
            }
            SyncanoLog.w(SendRequest.class.getSimpleName(), "Can't update object " + this.data.getClass().getSimpleName() + " from " + this.resultType.getSimpleName());
        }
        return super.parseResult(response, json);
    }

    @Override
    public T getResultObject() {
        return (T)this.data;
    }

    @Override
    public Request.RunAfter<T> getRunAfter() {
        return this.runAfter;
    }

    @Override
    public void setRunAfter(Request.RunAfter<T> runAfter) {
        this.runAfter = runAfter;
    }
}

