/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.syncano.library.Syncano;
import com.syncano.library.api.FieldsFilter;
import com.syncano.library.api.ResultRequest;
import com.syncano.library.choice.FilterType;
import java.util.List;

public class RequestGet<T>
extends ResultRequest<T> {
    private FieldsFilter fieldsFilter;
    private Integer requestedId;

    public RequestGet(Class<T> resultType, String url, Syncano syncano, int id) {
        this(resultType, url, syncano);
        this.requestedId = id;
        this.addCorrectHttpResponseCode(200);
    }

    public RequestGet(Class<T> resultType, String url, Syncano syncano) {
        super(resultType, url, syncano);
        this.addCorrectHttpResponseCode(200);
    }

    public RequestGet(T dataObject, String url, Syncano syncano) {
        super(dataObject, url, syncano);
        this.addCorrectHttpResponseCode(200);
    }

    public RequestGet(String url, Syncano syncano) {
        super(url, syncano);
        this.addCorrectHttpResponseCode(200);
    }

    @Override
    public String getRequestMethod() {
        return "GET";
    }

    @Override
    public void prepareUrlParams() {
        super.prepareUrlParams();
        if (this.isFieldsFilter()) {
            this.addUrlParam(this.fieldsFilter.getFilterTypeString(), this.createFilterFieldParam());
        }
    }

    public Integer getRequestedId() {
        return this.requestedId;
    }

    private String createFilterFieldParam() {
        StringBuilder filterFields = new StringBuilder();
        for (String fieldName : this.fieldsFilter.getFieldNames()) {
            if (filterFields.length() != 0) {
                filterFields.append(',');
            }
            filterFields.append(fieldName);
        }
        return filterFields.toString();
    }

    private boolean isFieldsFilter() {
        return this.fieldsFilter != null && this.fieldsFilter.getFieldNames() != null && this.fieldsFilter.getFieldNames().size() > 0;
    }

    public RequestGet<T> setFieldsFilter(FieldsFilter fieldsFilter) {
        this.fieldsFilter = fieldsFilter;
        return this;
    }

    public RequestGet<T> selectFields(FilterType filterType, String ... fields) {
        this.fieldsFilter = new FieldsFilter(filterType, fields);
        return this;
    }

    public RequestGet<T> selectFields(FilterType filterType, List<String> fields) {
        this.fieldsFilter = new FieldsFilter(filterType, fields);
        return this;
    }
}

