/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.syncano.library.PlatformType;
import com.syncano.library.Syncano;
import com.syncano.library.api.Response;
import com.syncano.library.callbacks.SyncanoCallback;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class Request<T> {
    private static final ExecutorService requestExecutor = Executors.newFixedThreadPool(3);
    protected Syncano syncano;

    public Request(Syncano syncano) {
        this.syncano = syncano;
    }

    public Response<T> instantiateResponse() {
        return new Response();
    }

    public abstract Response<T> send();

    public Syncano getSyncano() {
        return this.syncano;
    }

    public void sendAsync(SyncanoCallback<T> callback) {
        Request.runAsync(this, callback);
    }

    public static <T> void runAsync(final Request<T> request, final SyncanoCallback<T> callback) {
        requestExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final Response response = request.send();
                if (callback == null) {
                    return;
                }
                PlatformType.get().runOnCallbackThread(new Runnable(){

                    @Override
                    public void run() {
                        if (response.isSuccess()) {
                            callback.success(response, response.getData());
                        } else {
                            callback.failure(response);
                        }
                    }
                });
            }
        });
    }

    public static interface RunAfter<T> {
        public void run(Response<T> var1);
    }
}

