/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library;

import com.syncano.library.ChannelConnectionListener;
import com.syncano.library.PlatformType;
import com.syncano.library.Syncano;
import com.syncano.library.api.Response;
import com.syncano.library.data.Notification;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ChannelConnection {
    private static final String TAG = ChannelConnection.class.getSimpleName();
    private Syncano syncano;
    private ChannelConnectionListener channelConnectionListener;
    private PollRequestLoop pollRequestLoop;
    private String channel;
    private String room;
    private int lastId;
    private boolean autoReconnect = false;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private int currentLoopId = 0;

    public ChannelConnection(Syncano syncano) {
        this(syncano, null);
    }

    public ChannelConnection(Syncano syncano, ChannelConnectionListener channelConnectionListener) {
        this.syncano = syncano;
        this.channelConnectionListener = channelConnectionListener;
    }

    public void start(String channel) {
        this.start(channel, null, 0);
    }

    public void start(String channel, String room) {
        this.start(channel, room, 0);
    }

    public void start(String channel, String room, int lastId) {
        this.channel = channel;
        this.room = room;
        this.lastId = lastId;
        if (this.pollRequestLoop != null) {
            this.pollRequestLoop.stop();
        }
        this.pollRequestLoop = new PollRequestLoop(this.currentLoopId++);
        this.executor.schedule(this.pollRequestLoop, 0L, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.pollRequestLoop != null) {
            this.pollRequestLoop.stop();
            this.pollRequestLoop = null;
        }
    }

    public ChannelConnectionListener getChannelConnectionListener() {
        return this.channelConnectionListener;
    }

    public void setChannelConnectionListener(ChannelConnectionListener channelConnectionListener) {
        this.channelConnectionListener = channelConnectionListener;
    }

    private void handleSuccess(final Response<Notification> response) {
        if (response.getData() != null) {
            this.lastId = response.getData().getId();
            if (this.channelConnectionListener != null) {
                PlatformType.get().runOnCallbackThread(new Runnable(){

                    @Override
                    public void run() {
                        ChannelConnection.this.channelConnectionListener.onNotification((Notification)response.getData());
                    }
                });
            }
        }
    }

    private void handleError(final Response<Notification> response) {
        if (this.channelConnectionListener != null) {
            PlatformType.get().runOnCallbackThread(new Runnable(){

                @Override
                public void run() {
                    ChannelConnection.this.channelConnectionListener.onError(response);
                }
            });
        }
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    private class PollRequestLoop
    implements Runnable {
        private boolean isRunning = true;
        private int id;

        public PollRequestLoop(int id) {
            this.id = id;
        }

        public void stop() {
            this.isRunning = false;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        @Override
        public void run() {
            while (this.isRunning) {
                Response responsePollFromChannel = ChannelConnection.this.syncano.pollChannel(ChannelConnection.this.channel, ChannelConnection.this.room, ChannelConnection.this.lastId).send();
                if (!this.isRunning) break;
                int respCode = responsePollFromChannel.getHttpResultCode();
                if (respCode == 200) {
                    ChannelConnection.this.handleSuccess(responsePollFromChannel);
                    continue;
                }
                if (respCode == 204 || respCode == 504) continue;
                ChannelConnection.this.handleError(responsePollFromChannel);
                this.isRunning = false;
                if (!ChannelConnection.this.autoReconnect) break;
                ChannelConnection.this.executor.schedule(new ConnectionStart(this.id), 5L, TimeUnit.SECONDS);
                break;
            }
        }
    }

    private class ConnectionStart
    implements Runnable {
        private int loopId;

        public ConnectionStart(int loopId) {
            this.loopId = loopId;
        }

        @Override
        public void run() {
            if (ChannelConnection.this.pollRequestLoop != null && ChannelConnection.this.pollRequestLoop.id == this.loopId) {
                ChannelConnection.this.start(ChannelConnection.this.channel, ChannelConnection.this.room, ChannelConnection.this.lastId);
            }
        }
    }
}

