package com.syncano.library.api;

public class Response<T> {

    /**
     * Everything is ok!
     */
    public final static int HTTP_CODE_SUCCESS = 200;

    /**
     * The request was successful and a resource was created.
     */
    public final static int HTTP_CODE_CREATED = 201;

    /**
     * The request was successful but there is no data to
     * return (usually after successful DELETE request).
     */
    public final static int HTTP_CODE_NO_CONTENT = 204;

    /**
     * There was no new data to return.
     */
    public final static int HTTP_CODE_NOT_MODIFIED = 304;

    /**
     * The request was invalid or cannot be otherwise served.
     * An accompanying error message will explain further.
     */
    public final static int HTTP_CODE_BAD_REUEST = 400;

    /**
     * Authentication credentials were missing or incorrect.
     */
    public final static int HTTP_CODE_UNAUTHORIZED = 401;

    /**
     * The request is understood, but it has been refused or
     * access is not allowed. An accompanying error message will explain why.
     */
    public final static int HTTP_CODE_FORBIDDEN = 403;

    /**
     * The URI requested is invalid or the resource requested, such as a user, does not exists.
     * Also returned when the requested format is not supported by the requested method.
     */
    public final static int HTTP_CODE_NOT_FOUND = 404;

    /**
     * Requested method is not supported for this resource.
     */
    public final static int HTTP_CODE_METHOD_NOT_ALLOWED = 405;

    /**
     * Something is broken. Please contact Syncano support.
     */
    public final static int HTTP_CODE_INTERNAL_SERVER_ERROR = 500;

    /**
     * Syncano is down. Contact support.
     */
    public final static int HTTP_CODE_BAD_GATEWAY = 502;

    /**
     * Syncano request timeout.
     */
    public final static int HTTP_CODE_GATEWAY_TIMEOUT = 504;

    /**
     * Status code when response is ok.
     */
    public final static int CODE_SUCCESS = 0;

    /**
     * Status code when Http error appeared.
     */
    public final static int CODE_HTTP_ERROR = 1;

    /**
     * Client Protocol Exception
     */
    public final static int CODE_CLIENT_PROTOCOL_EXCEPTION = 2;

    /**
     * Illegal State Exception.
     */
    public final static int CODE_ILLEGAL_STATE_EXCEPTION = 3;

    /**
     * IOException.
     */
    public final static int CODE_ILLEGAL_IO_EXCEPTION = 4;

    /**
     * Parsing exception.
     */
    public final static int CODE_PARSING_RESPONSE_EXCEPTION = 5;

    /**
     * Unknown
     */
    public final static int CODE_UNKNOWN_ERROR = 6;


    /**
     * Internal results code.
     */
    private int resultCode;

    /**
     * Http results code.
     */
    private int httpResultCode;

    /**
     * Error when something went wrong.
     */
    private String error;

    /**
     * Error when something went wrong.
     */
    private String httpReasonPhrase;

    /**
     * Parsed result from server.
     */
    private T data;

    private boolean dataFromLocalStorage = false;

    /**
     * Returns true if result is success.
     *
     * @return true if result is success
     */
    public boolean isSuccess() {
        return resultCode == CODE_SUCCESS;
    }

    public int getResultCode() {
        return resultCode;
    }

    public Response<T> setResultCode(Integer resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    public int getHttpResultCode() {
        return httpResultCode;
    }

    public Response<T> setHttpResultCode(Integer httpResultCode) {
        this.httpResultCode = httpResultCode;
        return this;
    }

    public String getError() {
        return error;
    }

    public Response<T> setError(String error) {
        this.error = error;
        return this;
    }

    public String getHttpReasonPhrase() {
        return httpReasonPhrase;
    }

    public Response<T> setHttpReasonPhrase(String httpReasonPhrase) {
        this.httpReasonPhrase = httpReasonPhrase;
        return this;
    }


    public T getData() {
        return data;
    }

    public Response<T> setData(T parsedData) {
        this.data = parsedData;
        return this;
    }

    @Override
    public String toString() {
        return "Response{" +
                "resultCode=" + resultCode +
                ", httpResultCode=" + httpResultCode +
                ", error='" + error + '\'' +
                ", httpReasonPhrase='" + httpReasonPhrase + '\'' +
                ", data=" + data +
                '}';
    }

    public boolean isDataFromLocalStorage() {
        return dataFromLocalStorage;
    }

    public Response<T> setDataFromLocalStorage(boolean dataFromLocalStorage) {
        this.dataFromLocalStorage = dataFromLocalStorage;
        return this;
    }
}
