/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.utils;

import com.syncano.library.utils.NanosDate;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTool {
    private static final TimeZone sUtc = TimeZone.getTimeZone("UTC");

    public static Date parseString(String stringDate) {
        if (stringDate == null || stringDate.length() == 0) {
            return null;
        }
        try {
            Date date = DateTool.parse(stringDate);
            return date;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Date parse(String stringDate) throws NumberFormatException {
        if (stringDate.length() != 27) {
            return null;
        }
        Calendar sCal = Calendar.getInstance(sUtc);
        int year = Integer.parseInt(stringDate.substring(0, 4));
        int month = Integer.parseInt(stringDate.substring(5, 7)) - 1;
        int day = Integer.parseInt(stringDate.substring(8, 10));
        int hourOfDay = Integer.parseInt(stringDate.substring(11, 13));
        int minute = Integer.parseInt(stringDate.substring(14, 16));
        int second = Integer.parseInt(stringDate.substring(17, 19));
        sCal.set(year, month, day, hourOfDay, minute, second);
        int millis = Integer.parseInt(stringDate.substring(20, 23));
        int nanos = Integer.parseInt(stringDate.substring(23, 26));
        sCal.set(14, millis);
        NanosDate nDate = new NanosDate(sCal.getTimeInMillis());
        nDate.setNanos(nanos);
        return nDate;
    }

    public static String parseDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar sCal = Calendar.getInstance(sUtc);
        sCal.setTime(date);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%04d", sCal.get(1)));
        sb.append('-');
        sb.append(String.format("%02d", sCal.get(2) + 1));
        sb.append('-');
        sb.append(String.format("%02d", sCal.get(5)));
        sb.append('T');
        sb.append(String.format("%02d", sCal.get(11)));
        sb.append(':');
        sb.append(String.format("%02d", sCal.get(12)));
        sb.append(':');
        sb.append(String.format("%02d", sCal.get(13)));
        sb.append('.');
        sb.append(String.format("%03d", sCal.get(14)));
        int nanos = 0;
        if (date instanceof NanosDate) {
            nanos = ((NanosDate)date).getNanos();
        }
        sb.append(String.format("%03d", nanos));
        sb.append('Z');
        return sb.toString();
    }
}

