/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.simple;

import com.syncano.library.Syncano;
import com.syncano.library.api.IncrementBuilder;
import com.syncano.library.api.RequestGet;
import com.syncano.library.api.Response;
import com.syncano.library.callbacks.SyncanoCallback;
import com.syncano.library.data.Entity;
import com.syncano.library.data.SyncanoObject;
import java.util.HashSet;

public abstract class ObjectRequestBuilder
extends Entity {
    private Syncano syncano;
    private IncrementBuilder incrementBuilder = new IncrementBuilder();
    private HashSet<String> fieldsToClear = new HashSet();

    public void clearField(String fieldName) {
        this.fieldsToClear.add(fieldName);
    }

    public void removeFromClearList(String fieldName) {
        this.fieldsToClear.remove(fieldName);
    }

    public boolean isOnClearList(String fieldName) {
        return this.fieldsToClear.contains(fieldName);
    }

    public IncrementBuilder getIncrementBuilder() {
        return this.incrementBuilder;
    }

    public <T extends SyncanoObject> T increment(String fieldName, int value) {
        this.incrementBuilder.increment(fieldName, value);
        return (T)((SyncanoObject)this);
    }

    public <T extends SyncanoObject> T decrement(String fieldName, int value) {
        this.incrementBuilder.decrement(fieldName, value);
        return (T)((SyncanoObject)this);
    }

    public Syncano getSyncano() {
        if (this.syncano == null) {
            return Syncano.getInstance();
        }
        return this.syncano;
    }

    public <T extends SyncanoObject> T on(Syncano syncano) {
        this.syncano = syncano;
        return (T)((SyncanoObject)this);
    }

    public <T extends SyncanoObject> Response<T> save() {
        if (this.getId() == null) {
            return this.getSyncano().createObject((SyncanoObject)this, true).send();
        }
        return this.getSyncano().updateObject((SyncanoObject)this, true).send();
    }

    public <T extends SyncanoObject> void save(SyncanoCallback<T> callback) {
        if (this.getId() == null) {
            this.getSyncano().createObject((SyncanoObject)this, false).sendAsync(callback);
        } else {
            this.getSyncano().updateObject((SyncanoObject)this, false).sendAsync(callback);
        }
    }

    public <T extends SyncanoObject> Response<T> delete() {
        return this.getSyncano().deleteObject((SyncanoObject)this).send();
    }

    public <T extends SyncanoObject> void delete(SyncanoCallback<T> callback) {
        this.getSyncano().deleteObject((SyncanoObject)this).sendAsync(callback);
    }

    public <T extends SyncanoObject> Response<T> fetch() {
        RequestGet<SyncanoObject> req = this.getSyncano().getObject((SyncanoObject)this);
        return req.send();
    }

    public <T extends SyncanoObject> void fetch(SyncanoCallback<T> callback) {
        RequestGet<SyncanoObject> req = this.getSyncano().getObject((SyncanoObject)this);
        req.sendAsync(callback);
    }
}

