/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.parser;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.syncano.library.choice.FieldType;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.parser.GsonParser;
import com.syncano.library.parser.SyncanoFieldNamingStrategy;
import com.syncano.library.utils.SyncanoClassHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;

public class SyncanoObjectDeserializer
implements JsonDeserializer<SyncanoObject> {
    private static final String FIELD_VALUE = "value";
    private SyncanoObject syncanoObject = null;
    private GsonParser.GsonParseConfig config;

    public SyncanoObjectDeserializer(Object syncanoObject, GsonParser.GsonParseConfig config) {
        if (syncanoObject != null && syncanoObject instanceof SyncanoObject) {
            this.syncanoObject = (SyncanoObject)syncanoObject;
        }
        this.config = config;
    }

    public SyncanoObject deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
        return this.parseSyncanoObject(this.syncanoObject, type, je, jdc);
    }

    private void setFieldFromJsonElement(SyncanoObject o, Field f, JsonDeserializationContext jdc, JsonElement je) {
        try {
            if (je == null || je.isJsonNull()) {
                f.set(o, null);
            } else if (SyncanoClassHelper.findType(f) == FieldType.REFERENCE) {
                f.set(o, this.parseSyncanoObject((SyncanoObject)f.get(o), f.getType(), je, jdc));
            } else {
                f.set(o, jdc.deserialize(je, f.getType()));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private SyncanoObject parseSyncanoObject(SyncanoObject syncanoObject, Type type, JsonElement je, JsonDeserializationContext jdc) {
        if (je.isJsonPrimitive() && !je.isJsonNull()) {
            return this.createSyncanoObjectWithId(syncanoObject, type, je.getAsInt());
        }
        JsonObject jo = je.getAsJsonObject();
        if (!jo.has("id") && jo.has(FIELD_VALUE)) {
            return this.createSyncanoObjectWithId(syncanoObject, type, jo.get(FIELD_VALUE).getAsInt());
        }
        if (syncanoObject == null) {
            syncanoObject = SyncanoObjectDeserializer.createSyncanoObject((Class)type);
        }
        Collection<Field> fields = SyncanoClassHelper.findAllSyncanoFields((Class)type);
        for (Field field : fields) {
            field.setAccessible(true);
            String syncanoKey = SyncanoClassHelper.getFieldName(field);
            JsonElement syncanoElement = jo.get(syncanoKey);
            this.setFieldFromJsonElement(syncanoObject, field, jdc, syncanoElement);
        }
        return syncanoObject;
    }

    private SyncanoObject createSyncanoObjectWithId(SyncanoObject oldObject, Type type, int id) {
        if (oldObject == null || oldObject.getId() == null || id != oldObject.getId()) {
            SyncanoObject newObject = SyncanoObjectDeserializer.createSyncanoObject((Class)type);
            newObject.setId(id);
            return newObject;
        }
        return oldObject;
    }

    public static SyncanoObject createSyncanoObject(Class<? extends SyncanoObject> clazz) {
        try {
            Constructor<? extends SyncanoObject> defaultConstructor = clazz.getConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Gson gson = new GsonBuilder().setFieldNamingStrategy((FieldNamingStrategy)new SyncanoFieldNamingStrategy()).create();
            return (SyncanoObject)gson.fromJson("{}", clazz);
        }
    }
}

