/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.parser;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public abstract class CustomizedTypeAdapterFactory<C>
implements TypeAdapterFactory {
    private final Class<C> customizedClass;

    public CustomizedTypeAdapterFactory(Class<C> customizedClass) {
        this.customizedClass = customizedClass;
    }

    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (this.customizedClass.isAssignableFrom(type.getRawType())) {
            return this.customizeMyClassAdapter(gson, type);
        }
        return null;
    }

    private TypeAdapter<C> customizeMyClassAdapter(Gson gson, final TypeToken<C> type) {
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
        return new TypeAdapter<C>(){

            public void write(JsonWriter out, C value) throws IOException {
                JsonElement tree = delegate.toJsonTree(value);
                CustomizedTypeAdapterFactory.this.beforeWrite(value, tree);
                elementAdapter.write(out, (Object)tree);
            }

            public C read(JsonReader in) throws IOException {
                JsonElement tree = (JsonElement)elementAdapter.read(in);
                CustomizedTypeAdapterFactory.this.afterRead(type, tree);
                return delegate.fromJsonTree(tree);
            }
        };
    }

    protected void beforeWrite(C source, JsonElement toSerialize) {
    }

    protected void afterRead(TypeToken<C> type, JsonElement deserialized) {
    }
}

