/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.data;

import com.syncano.library.Syncano;
import com.syncano.library.annotation.SyncanoField;
import com.syncano.library.api.Response;
import com.syncano.library.callbacks.SyncanoCallback;
import com.syncano.library.choice.TraceStatus;
import java.util.Date;

public class Trace {
    public static final String FIELD_ID = "id";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_DURATION = "duration";
    public static final String FIELD_RESULT = "result";
    public static final String FIELD_EXECUTED_AT = "executed_at";
    public static final String FIELD_STDERR = "stderr";
    public static final String FIELD_STDOUT = "stdout";
    public static final String FIELD_RESPONSE = "response";
    public static final String FIELD_CONTENT = "content";
    public static final String FIELD_CONTENT_TYPE = "content_type";
    @SyncanoField(name="id", readOnly=true)
    private int id;
    @SyncanoField(name="status", readOnly=true)
    private TraceStatus status;
    @SyncanoField(name="duration", readOnly=true)
    private int duration;
    @SyncanoField(name="result", readOnly=true)
    private TraceResult result;
    @SyncanoField(name="executed_at", readOnly=true)
    private Date executedAt;
    private Integer scriptId = null;
    private Syncano syncano;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Deprecated
    public Integer getCodeBoxId() {
        return this.getScriptId();
    }

    @Deprecated
    public void setCodeBoxId(int id) {
        this.setScriptId(id);
    }

    public Integer getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(int id) {
        this.scriptId = id;
    }

    public TraceStatus getStatus() {
        return this.status;
    }

    public void setStatus(TraceStatus status) {
        this.status = status;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public TraceResult getResult() {
        return this.result;
    }

    public void setResult(TraceResult result) {
        this.result = result;
    }

    public Date getExecutedAt() {
        return this.executedAt;
    }

    public void setExecutedAt(Date executedAt) {
        this.executedAt = executedAt;
    }

    private Syncano getSyncano() {
        if (this.syncano == null) {
            return Syncano.getInstance();
        }
        return this.syncano;
    }

    public Trace on(Syncano syncano) {
        this.syncano = syncano;
        return this;
    }

    public Response<Trace> fetch() {
        return this.getSyncano().getTrace(this).send();
    }

    public void fetch(SyncanoCallback<Trace> callback) {
        this.getSyncano().getTrace(this).sendAsync(callback);
    }

    public String getOutput() {
        if (this.result != null) {
            return this.result.stdout;
        }
        return null;
    }

    public String getErrorOutput() {
        if (this.result != null) {
            return this.result.stderr;
        }
        return null;
    }

    public TraceResponse getResponse() {
        if (this.result != null) {
            return this.result.response;
        }
        return null;
    }

    public static class TraceResponse {
        @SyncanoField(name="status", readOnly=true)
        public Integer status;
        @SyncanoField(name="content", readOnly=true)
        public String content;
        @SyncanoField(name="content_type", readOnly=true)
        public String contentType;
    }

    private static class TraceResult {
        @SyncanoField(name="stderr", readOnly=true)
        public String stderr;
        @SyncanoField(name="stdout", readOnly=true)
        public String stdout;
        @SyncanoField(name="response", readOnly=true)
        public TraceResponse response;

        private TraceResult() {
        }
    }
}

