/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.google.gson.Gson;
import com.syncano.library.Syncano;
import com.syncano.library.api.HttpRequest;
import com.syncano.library.api.Response;
import com.syncano.library.parser.GsonParser;

public abstract class ResultRequest<T>
extends HttpRequest<T> {
    protected Class<T> resultType = null;
    private Gson gson = null;
    private T resultObject;

    protected ResultRequest(Class<T> resultType, String url, Syncano syncano) {
        super(url, syncano);
        this.gson = GsonParser.createGson(resultType);
        this.resultType = resultType;
    }

    protected ResultRequest(T dataObject, String url, Syncano syncano) {
        super(url, syncano);
        this.gson = GsonParser.createGson(dataObject);
        this.resultObject = dataObject;
        this.resultType = dataObject.getClass();
    }

    protected ResultRequest(String url, Syncano syncano) {
        super(url, syncano);
    }

    public T getResultObject() {
        return this.resultObject;
    }

    @Override
    public T parseResult(Response<T> response, String json) {
        if (this.resultType.equals(String.class)) {
            return (T)json;
        }
        return (T)this.gson.fromJson(json, this.resultType);
    }

    public Class getResultType() {
        return this.resultType;
    }
}

