/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;

public final class IncrementBuilder {
    private static final String SYNCANO_INCREMENT_OR_DECREMENT = "_increment";
    private HashMap<String, Integer> additionField = new HashMap();

    public IncrementBuilder increment(String fieldName, int value) {
        this.additionField.put(fieldName, value);
        return this;
    }

    public IncrementBuilder decrement(String fieldName, int value) {
        this.additionField.put(fieldName, -value);
        return this;
    }

    public boolean hasAdditionFields() {
        return this.additionField.isEmpty();
    }

    public void build(JsonObject json) {
        for (Map.Entry<String, Integer> entry : this.additionField.entrySet()) {
            JsonObject jsonIncrementer = new JsonObject();
            jsonIncrementer.addProperty(SYNCANO_INCREMENT_OR_DECREMENT, (Number)entry.getValue());
            json.add(entry.getKey(), (JsonElement)jsonIncrementer);
        }
    }
}

