/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.google.gson.JsonElement;
import com.syncano.library.Syncano;
import com.syncano.library.api.Request;
import com.syncano.library.api.Response;
import com.syncano.library.utils.SyncanoHttpClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public abstract class HttpRequest<T>
extends Request<T> {
    private List<NameValuePair> urlParams = new ArrayList<NameValuePair>();
    private List<NameValuePair> httpHeaders = new ArrayList<NameValuePair>();
    private String url;
    private String path;
    private String completeCustomUrl;
    private HashSet<Integer> correctHttpResponse = new HashSet();
    private boolean longConnectionTimeout = false;
    private boolean strictCheckCertificate = false;

    protected HttpRequest(String path, Syncano syncano) {
        super(syncano);
        this.path = path;
        this.url = syncano.getUrl();
        this.strictCheckCertificate = syncano.isStrictCheckedCertificate();
        if (syncano.getApiKey() != null && !syncano.getApiKey().isEmpty()) {
            this.setHttpHeader("X-API-KEY", syncano.getApiKey());
        }
        if (syncano.getUserKey() != null && !syncano.getUserKey().isEmpty()) {
            this.setHttpHeader("X-USER-KEY", syncano.getUserKey());
        }
    }

    public abstract String getRequestMethod();

    public HttpEntity prepareParams() {
        return null;
    }

    public JsonElement prepareJsonParams() {
        return null;
    }

    public boolean isStrictCheckedCertificate() {
        return this.strictCheckCertificate;
    }

    public void prepareUrlParams() {
    }

    public void addCorrectHttpResponseCode(int code) {
        this.correctHttpResponse.add(code);
    }

    public boolean isCorrectHttpResponseCode(int code) {
        return this.correctHttpResponse.contains(code);
    }

    public void addUrlParam(String key, String value) {
        this.urlParams.add((NameValuePair)new BasicNameValuePair(key, value));
    }

    public String getUrlParams() {
        this.prepareUrlParams();
        if (this.urlParams == null || this.urlParams.isEmpty()) {
            return "";
        }
        StringBuilder postData = new StringBuilder();
        for (NameValuePair param : this.urlParams) {
            if (postData.length() != 0) {
                postData.append('&');
            } else {
                postData.append("?");
            }
            String name = null;
            String value = null;
            try {
                name = URLEncoder.encode(param.getName(), "UTF-8");
                value = URLEncoder.encode(param.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            postData.append(name).append('=').append(value);
        }
        return postData.toString();
    }

    public void setHttpHeader(String name, String value) {
        this.removeHttpHeader(name);
        this.httpHeaders.add((NameValuePair)new BasicNameValuePair(name, value));
    }

    public void removeHttpHeader(String name) {
        for (NameValuePair pair : this.httpHeaders) {
            if (!name.equals(pair.getName())) continue;
            this.httpHeaders.remove(pair);
            return;
        }
    }

    public List<NameValuePair> getHttpHeaders() {
        return this.httpHeaders;
    }

    public String getUrlPath() {
        return this.path;
    }

    public String getUrl() {
        String fullUrl = this.getCompleteCustomUrl() != null ? this.getCompleteCustomUrl() + this.getUrlParams() : this.url + this.getUrlPath() + this.getUrlParams();
        return fullUrl;
    }

    public abstract T parseResult(Response<T> var1, String var2);

    @Override
    public Response<T> send() {
        SyncanoHttpClient http = new SyncanoHttpClient();
        if (this.getLongConnectionTimeout()) {
            http.setTimeout(360000);
        }
        Response response = http.send(this);
        if (this.getRunAfter() != null) {
            this.getRunAfter().run(response);
        }
        return response;
    }

    public String getCompleteCustomUrl() {
        return this.completeCustomUrl;
    }

    public void setCompleteCustomUrl(String completeCustomUrl) {
        this.completeCustomUrl = completeCustomUrl;
    }

    public String getContentType() {
        return "application/json";
    }

    public void setLongConnectionTimeout() {
        this.longConnectionTimeout = true;
    }

    public boolean getLongConnectionTimeout() {
        return this.longConnectionTimeout;
    }
}

