/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syncano.library.Syncano;
import com.syncano.library.api.BatchRequest;
import com.syncano.library.api.HttpRequest;
import com.syncano.library.api.Response;
import com.syncano.library.callbacks.SyncanoCallback;
import com.syncano.library.data.BatchAnswer;
import java.util.ArrayList;
import java.util.List;

public class BatchBuilder {
    public static final int MAX_BATCH = 50;
    private ArrayList<HttpRequest> requests = new ArrayList();
    private Syncano syncano;

    public BatchBuilder(Syncano syncano) {
        this.syncano = syncano;
    }

    public BatchBuilder add(HttpRequest httpRequest) {
        this.requests.add(httpRequest);
        return this;
    }

    public BatchRequest buildRequest() {
        if (this.requests.size() > 50) {
            throw new RuntimeException("Maximum batch size 50 exceeded");
        }
        if (this.requests.size() == 0) {
            throw new RuntimeException("Trying to send 0 requests in a batch");
        }
        JsonArray array = new JsonArray();
        for (HttpRequest r : this.requests) {
            if (r.getCompleteCustomUrl() != null) {
                throw new RuntimeException("Can't send completely custom url request in batch");
            }
            if (r.getUrlPath() == null) {
                throw new RuntimeException("Can't send request without url path in batch");
            }
            JsonObject reqJson = new JsonObject();
            reqJson.addProperty("method", r.getRequestMethod());
            reqJson.addProperty("path", r.getUrlPath() + r.getUrlParams());
            JsonElement body = r.prepareJsonParams();
            if (body != null) {
                reqJson.add("body", body);
            }
            array.add((JsonElement)reqJson);
        }
        JsonObject json = new JsonObject();
        json.add("requests", (JsonElement)array);
        String url = String.format("/v1.1/instances/%s/batch/", this.syncano.getNotEmptyInstanceName());
        return new BatchRequest(url, this.syncano, (JsonElement)json);
    }

    public Response<List<BatchAnswer>> send() {
        return this.buildRequest().send();
    }

    public void sendAsync(SyncanoCallback<List<BatchAnswer>> callback) {
        this.buildRequest().sendAsync(callback);
    }
}

