/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library;

import android.content.Context;
import com.google.gson.JsonObject;
import com.syncano.library.Syncano;
import com.syncano.library.api.Request;
import com.syncano.library.api.RequestDelete;
import com.syncano.library.api.RequestGet;
import com.syncano.library.api.RequestGetList;
import com.syncano.library.api.RequestPatch;
import com.syncano.library.api.RequestPost;
import com.syncano.library.api.Response;
import com.syncano.library.data.AbstractUser;
import com.syncano.library.data.Channel;
import com.syncano.library.data.CodeBox;
import com.syncano.library.data.DataEndpoint;
import com.syncano.library.data.Group;
import com.syncano.library.data.GroupMembership;
import com.syncano.library.data.Script;
import com.syncano.library.data.ScriptEndpoint;
import com.syncano.library.data.SyncanoClass;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.data.SyncanoTableView;
import com.syncano.library.data.Template;
import com.syncano.library.data.User;
import com.syncano.library.data.Webhook;
import com.syncano.library.utils.SyncanoClassHelper;
import com.syncano.library.utils.Validate;

public class SyncanoDashboard
extends Syncano {
    public SyncanoDashboard() {
    }

    public SyncanoDashboard(String instanceName) {
        super(instanceName);
    }

    public SyncanoDashboard(String apiKey, String instanceName) {
        super(apiKey, instanceName);
    }

    public SyncanoDashboard(String apiKey, String instanceName, Context androidContext) {
        super(apiKey, instanceName, androidContext);
    }

    public SyncanoDashboard(String customServerUrl, String apiKey, String instanceName) {
        super(customServerUrl, apiKey, instanceName);
    }

    public SyncanoDashboard(String customServerUrl, String apiKey, String instanceName, Context androidContext) {
        super(customServerUrl, apiKey, instanceName, androidContext);
    }

    public SyncanoDashboard(String customServerUrl, String apiKey, String instanceName, Context androidContext, boolean useLoggedUserStorage) {
        super(customServerUrl, apiKey, instanceName, androidContext, useLoggedUserStorage);
    }

    @Deprecated
    public RequestPost<CodeBox> createCodeBox(CodeBox codeBox) {
        String url = String.format("/v1.1/instances/%s/snippets/scripts/", this.getNotEmptyInstanceName());
        return new RequestPost<CodeBox>(CodeBox.class, url, this, codeBox);
    }

    public RequestPost<Script> createScript(Script script) {
        String url = String.format("/v1.1/instances/%s/snippets/scripts/", this.getNotEmptyInstanceName());
        return new RequestPost<Script>(Script.class, url, this, script);
    }

    @Deprecated
    public RequestGet<CodeBox> getCodeBox(int id) {
        String url = String.format("/v1.1/instances/%s/snippets/scripts/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestGet<Class<CodeBox>>(CodeBox.class, url, (Syncano)this);
    }

    public RequestGet<Script> getScript(int id) {
        String url = String.format("/v1.1/instances/%s/snippets/scripts/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestGet<Class<Script>>(Script.class, url, (Syncano)this);
    }

    @Deprecated
    public RequestGetList<CodeBox> getCodeBoxes() {
        String url = String.format("/v1.1/instances/%s/snippets/scripts/", this.getNotEmptyInstanceName());
        return new RequestGetList<CodeBox>(CodeBox.class, url, (Syncano)this);
    }

    public RequestGetList<Script> getScripts() {
        String url = String.format("/v1.1/instances/%s/snippets/scripts/", this.getNotEmptyInstanceName());
        return new RequestGetList<Script>(Script.class, url, (Syncano)this);
    }

    @Deprecated
    public RequestPatch<CodeBox> updateCodeBox(CodeBox codeBox) {
        Validate.checkNotNullAndZero(codeBox.getId(), "Trying to update object without id!");
        String url = String.format("/v1.1/instances/%s/snippets/scripts/%d/", this.getNotEmptyInstanceName(), codeBox.getId());
        return new RequestPatch<CodeBox>(CodeBox.class, url, this, codeBox);
    }

    public RequestPatch<Script> updateScript(Script script) {
        Validate.checkNotNullAndZero(script.getId(), "Trying to update object without id!");
        String url = String.format("/v1.1/instances/%s/snippets/scripts/%d/", this.getNotEmptyInstanceName(), script.getId());
        return new RequestPatch<Script>(Script.class, url, this, script);
    }

    @Deprecated
    public RequestDelete<CodeBox> deleteCodeBox(int id) {
        String url = String.format("/v1.1/instances/%s/snippets/scripts/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestDelete<CodeBox>(CodeBox.class, url, (Syncano)this);
    }

    public RequestDelete<Script> deleteScript(int id) {
        String url = String.format("/v1.1/instances/%s/snippets/scripts/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestDelete<Script>(Script.class, url, (Syncano)this);
    }

    @Deprecated
    public RequestPost<Webhook> createWebhook(final Webhook webhook) {
        String url = String.format("/v1.1/instances/%s/endpoints/scripts/", this.getNotEmptyInstanceName());
        RequestPost<Webhook> req = new RequestPost<Webhook>(Webhook.class, url, this, webhook);
        req.updateGivenObject(true);
        req.setRunAfter(new Request.RunAfter<Webhook>(){

            @Override
            public void run(Response<Webhook> response) {
                webhook.on(SyncanoDashboard.this);
            }
        });
        return req;
    }

    public RequestPost<ScriptEndpoint> createScriptEndpoint(final ScriptEndpoint scriptEndpoint) {
        String url = String.format("/v1.1/instances/%s/endpoints/scripts/", this.getNotEmptyInstanceName());
        RequestPost<ScriptEndpoint> req = new RequestPost<ScriptEndpoint>(ScriptEndpoint.class, url, this, scriptEndpoint);
        req.updateGivenObject(true);
        req.setRunAfter(new Request.RunAfter<ScriptEndpoint>(){

            @Override
            public void run(Response<ScriptEndpoint> response) {
                scriptEndpoint.on(SyncanoDashboard.this);
            }
        });
        return req;
    }

    @Deprecated
    public RequestGet<Webhook> getWebhook(String name) {
        String url = String.format("/v1.1/instances/%s/endpoints/scripts/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestGet<Class<Webhook>>(Webhook.class, url, (Syncano)this);
    }

    public RequestGet<ScriptEndpoint> getScriptEndpoint(String name) {
        String url = String.format("/v1.1/instances/%s/endpoints/scripts/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestGet<Class<ScriptEndpoint>>(ScriptEndpoint.class, url, (Syncano)this);
    }

    @Deprecated
    public RequestGetList<Webhook> getWebhooks() {
        String url = String.format("/v1.1/instances/%s/endpoints/scripts/", this.getNotEmptyInstanceName());
        return new RequestGetList<Webhook>(Webhook.class, url, (Syncano)this);
    }

    public RequestGetList<ScriptEndpoint> getScriptEndpoints() {
        String url = String.format("/v1.1/instances/%s/endpoints/scripts/", this.getNotEmptyInstanceName());
        return new RequestGetList<ScriptEndpoint>(ScriptEndpoint.class, url, (Syncano)this);
    }

    @Deprecated
    public RequestPatch<Webhook> updateWebhook(Webhook webhook) {
        Validate.checkNotNullAndNotEmpty(webhook.getName(), "Trying to update Webhook without name!");
        String url = String.format("/v1.1/instances/%s/endpoints/scripts/%s/", this.getNotEmptyInstanceName(), webhook.getName());
        return new RequestPatch<Webhook>(Webhook.class, url, this, webhook);
    }

    public RequestPatch<ScriptEndpoint> updateScriptEndpoint(ScriptEndpoint scriptEndpoint) {
        Validate.checkNotNullAndNotEmpty(scriptEndpoint.getName(), "Trying to update ScriptEndpoint without name!");
        String url = String.format("/v1.1/instances/%s/endpoints/scripts/%s/", this.getNotEmptyInstanceName(), scriptEndpoint.getName());
        return new RequestPatch<ScriptEndpoint>(ScriptEndpoint.class, url, this, scriptEndpoint);
    }

    @Deprecated
    public RequestDelete<Webhook> deleteWebhook(String name) {
        String url = String.format("/v1.1/instances/%s/endpoints/scripts/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestDelete<Webhook>(Webhook.class, url, (Syncano)this);
    }

    public RequestDelete<ScriptEndpoint> deleteScriptEndpoint(String name) {
        String url = String.format("/v1.1/instances/%s/endpoints/scripts/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestDelete<ScriptEndpoint>(ScriptEndpoint.class, url, (Syncano)this);
    }

    public RequestPost<SyncanoClass> createSyncanoClass(SyncanoClass clazz) {
        String url = String.format("/v1.1/instances/%s/classes/", this.getNotEmptyInstanceName());
        return new RequestPost<SyncanoClass>(SyncanoClass.class, url, this, clazz);
    }

    @Deprecated
    public RequestPost<SyncanoTableView> createTableView(SyncanoTableView clazz) {
        String url = String.format("/v1.1/instances/%s/endpoints/data/", this.getNotEmptyInstanceName());
        return new RequestPost<SyncanoTableView>(SyncanoTableView.class, url, this, clazz);
    }

    public RequestPost<DataEndpoint> createDataEndpoint(DataEndpoint dataEndpoint) {
        String url = String.format("/v1.1/instances/%s/endpoints/data/", this.getNotEmptyInstanceName());
        return new RequestPost<DataEndpoint>(DataEndpoint.class, url, this, dataEndpoint);
    }

    @Deprecated
    public RequestDelete<SyncanoTableView> deleteTableView(String name) {
        String url = String.format("/v1.1/instances/%s/endpoints/data/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestDelete<SyncanoTableView>(SyncanoTableView.class, url, (Syncano)this);
    }

    public RequestDelete<DataEndpoint> deleteDataEndpoint(String name) {
        String url = String.format("/v1.1/instances/%s/endpoints/data/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestDelete<DataEndpoint>(DataEndpoint.class, url, (Syncano)this);
    }

    public RequestPost<SyncanoClass> createSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.createSyncanoClass(new SyncanoClass(clazz));
    }

    public RequestGet<SyncanoClass> getSyncanoClass(String name) {
        String url = String.format("/v1.1/instances/%s/classes/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestGet<Class<SyncanoClass>>(SyncanoClass.class, url, (Syncano)this);
    }

    public RequestGet<SyncanoClass> getSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.getSyncanoClass(SyncanoClassHelper.getSyncanoClassName(clazz));
    }

    public RequestGetList<SyncanoClass> getSyncanoClasses() {
        String url = String.format("/v1.1/instances/%s/classes/", this.getNotEmptyInstanceName());
        return new RequestGetList<SyncanoClass>(SyncanoClass.class, url, (Syncano)this);
    }

    public RequestPatch<SyncanoClass> updateSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.updateSyncanoClass(new SyncanoClass(clazz));
    }

    public RequestPatch<SyncanoClass> updateSyncanoClass(SyncanoClass clazz) {
        Validate.checkNotNullAndNotEmpty(clazz.getName(), "Trying to update SyncanoClass without giving name!");
        String url = String.format("/v1.1/instances/%s/classes/%s/", this.getNotEmptyInstanceName(), clazz.getName());
        return new RequestPatch<SyncanoClass>(SyncanoClass.class, url, this, clazz);
    }

    public RequestDelete<SyncanoClass> deleteSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.deleteSyncanoClass(SyncanoClassHelper.getSyncanoClassName(clazz));
    }

    public RequestDelete<SyncanoClass> deleteSyncanoClass(String name) {
        String url = String.format("/v1.1/instances/%s/classes/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestDelete<SyncanoClass>(SyncanoClass.class, url, (Syncano)this);
    }

    public RequestDelete<User> deleteUser(int id) {
        return this.deleteUser(User.class, id);
    }

    public <T extends AbstractUser> RequestDelete<T> deleteUser(Class<T> type, int id) {
        String url = String.format("/v1.1/instances/%s/users/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestDelete<T>(type, url, (Syncano)this);
    }

    public RequestPost<Group> createGroup(Group group) {
        String url = String.format("/v1.1/instances/%s/groups/", this.getNotEmptyInstanceName());
        return new RequestPost<Group>(Group.class, url, this, group);
    }

    public RequestGet<Group> getGroup(int id) {
        String url = String.format("/v1.1/instances/%s/groups/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestGet<Class<Group>>(Group.class, url, (Syncano)this);
    }

    public RequestGetList<Group> getGroups() {
        String url = String.format("/v1.1/instances/%s/groups/", this.getNotEmptyInstanceName());
        return new RequestGetList<Group>(Group.class, url, (Syncano)this);
    }

    public RequestPatch<Group> updateGroup(Group group) {
        Validate.checkNotNullAndZero(group.getId(), "Trying to update Group without id!");
        String url = String.format("/v1.1/instances/%s/groups/%d/", this.getNotEmptyInstanceName(), group.getId());
        return new RequestPatch<Group>(Group.class, url, this, group);
    }

    public RequestDelete<Group> deleteGroup(int id) {
        String url = String.format("/v1.1/instances/%s/groups/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestDelete<Group>(Group.class, url, (Syncano)this);
    }

    public RequestGet<GroupMembership> getGroupMembership(int groupId, int userId) {
        String url = String.format("/v1.1/instances/%s/groups/%d/users/%d/", this.getNotEmptyInstanceName(), groupId, userId);
        return new RequestGet<Class<GroupMembership>>(GroupMembership.class, url, (Syncano)this);
    }

    public RequestGetList<GroupMembership> getGroupMemberships(int groupId) {
        String url = String.format("/v1.1/instances/%s/groups/%d/users/", this.getNotEmptyInstanceName(), groupId);
        return new RequestGetList<GroupMembership>(GroupMembership.class, url, (Syncano)this);
    }

    public RequestPost<GroupMembership> addUserToGroup(int groupId, int userId) {
        String url = String.format("/v1.1/instances/%s/groups/%d/users/", this.getNotEmptyInstanceName(), groupId);
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("user", (Number)userId);
        return new RequestPost<GroupMembership>(GroupMembership.class, url, this, jsonParams);
    }

    public RequestDelete<GroupMembership> deleteUserFromGroup(int groupId, int userId) {
        String url = String.format("/v1.1/instances/%s/groups/%d/users/%d/", this.getNotEmptyInstanceName(), groupId, userId);
        return new RequestDelete<GroupMembership>(GroupMembership.class, url, (Syncano)this);
    }

    public RequestPost<Channel> createChannel(Channel channel) {
        String url = String.format("/v1.1/instances/%s/channels/", this.getNotEmptyInstanceName());
        return new RequestPost<Channel>(Channel.class, url, this, channel);
    }

    public RequestGet<Channel> getChannel(String channelName) {
        String url = String.format("/v1.1/instances/%s/channels/%s/", this.getNotEmptyInstanceName(), channelName);
        return new RequestGet<Class<Channel>>(Channel.class, url, (Syncano)this);
    }

    public RequestGetList<Channel> getChannels() {
        String url = String.format("/v1.1/instances/%s/channels/", this.getNotEmptyInstanceName());
        return new RequestGetList<Channel>(Channel.class, url, (Syncano)this);
    }

    public RequestPatch<Channel> updateChannel(Channel channel) {
        Validate.checkNotNullAndNotEmpty(channel.getName(), "Trying to update Channel without name!");
        String url = String.format("/v1.1/instances/%s/channels/%s/", this.getNotEmptyInstanceName(), channel.getName());
        return new RequestPatch<Channel>(Channel.class, url, this, channel);
    }

    public RequestDelete<Channel> deleteChannel(String channelName) {
        String url = String.format("/v1.1/instances/%s/channels/%s/", this.getNotEmptyInstanceName(), channelName);
        return new RequestDelete<Channel>(Channel.class, url, (Syncano)this);
    }

    public RequestGetList<User> getUsers() {
        return this.getUsers(User.class);
    }

    public <T extends AbstractUser> RequestGetList<T> getUsers(Class<T> type) {
        String url = String.format("/v1.1/instances/%s/users/", this.getNotEmptyInstanceName());
        return new RequestGetList<T>(type, url, (Syncano)this);
    }

    public RequestGetList<Template> getTemplates() {
        String url = String.format("/v1.1/instances/%s/snippets/templates/", this.getNotEmptyInstanceName());
        return new RequestGetList<Template>(Template.class, url, (Syncano)this);
    }

    public RequestGet<Template> getTemplate(String templateName) {
        String url = String.format("/v1.1/instances/%s/snippets/templates/%s/", this.getNotEmptyInstanceName(), templateName);
        return new RequestGet<Class<Template>>(Template.class, url, (Syncano)this);
    }

    public RequestPost<Template> createTemplate(Template template) {
        String url = String.format("/v1.1/instances/%s/snippets/templates/", this.getNotEmptyInstanceName());
        return new RequestPost<Template>(Template.class, url, this, template);
    }

    public RequestDelete<Void> deleteTemplate(String templateName) {
        String url = String.format("/v1.1/instances/%s/snippets/templates/%s/", this.getNotEmptyInstanceName(), templateName);
        return new RequestDelete<Void>(Void.class, url, (Syncano)this);
    }

    public RequestPatch<Template> updateTemplate(Template template) {
        Validate.checkNotNullAndNotEmpty(template.getName(), "Trying to update Template without a name!");
        String url = String.format("/v1.1/instances/%s/snippets/templates/%s/", this.getNotEmptyInstanceName(), template.getName());
        return new RequestPatch<Template>(Template.class, url, this, template);
    }

    public RequestPost<Template> renameTemplate(String oldName, String newName) {
        String url = String.format("/v1.1/instances/%s/snippets/templates/%s/rename/", this.getNotEmptyInstanceName(), oldName);
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("new_name", newName);
        return new RequestPost<Template>(Template.class, url, this, jsonParams);
    }
}

