/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library;

import android.content.Context;
import com.syncano.library.Syncano;
import com.syncano.library.SyncanoDashboard;

public class SyncanoBuilder {
    private String instanceName = null;
    private String apiKey = null;
    private String customServerUrl = null;
    private boolean useLoggedUserStorage = true;
    private boolean strictCheckCertificate = false;
    private Context androidContext = null;
    private boolean global = true;

    public SyncanoBuilder instanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public SyncanoBuilder apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public SyncanoBuilder customServerUrl(String customServerUrl) {
        this.customServerUrl = customServerUrl;
        return this;
    }

    public SyncanoBuilder useLoggedUserStorage(boolean rememberUser) {
        this.useLoggedUserStorage = rememberUser;
        return this;
    }

    public SyncanoBuilder strictCheckCertificate(boolean strictCheckCertificate) {
        this.strictCheckCertificate = strictCheckCertificate;
        return this;
    }

    public SyncanoBuilder androidContext(Context androidContext) {
        this.androidContext = androidContext;
        return this;
    }

    public SyncanoBuilder setAsGlobalInstance(boolean global) {
        this.global = global;
        return this;
    }

    public Syncano build() {
        SyncanoDashboard s = new SyncanoDashboard(this.customServerUrl, this.apiKey, this.instanceName, this.androidContext, this.useLoggedUserStorage);
        s.setStrictCheckCertificate(this.strictCheckCertificate);
        if (this.global) {
            Syncano.setInstance(s);
        }
        return s;
    }
}

