/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library;

import com.syncano.library.ChannelConnectionListener;
import com.syncano.library.PlatformType;
import com.syncano.library.Syncano;
import com.syncano.library.api.Response;
import com.syncano.library.data.Notification;

public class ChannelConnection {
    private static final String TAG = ChannelConnection.class.getSimpleName();
    private static final int ERROR_DELAY = 1000;
    private Syncano syncano;
    private ChannelConnectionListener channelConnectionListener;
    private PollRequestLoop pollRequestLoop;
    private String channel;
    private String room;
    private int lastId;
    private boolean hasError;

    public ChannelConnection(Syncano syncano) {
        this(syncano, null);
    }

    public ChannelConnection(Syncano syncano, ChannelConnectionListener channelConnectionListener) {
        this.syncano = syncano;
        this.channelConnectionListener = channelConnectionListener;
    }

    public void start(String channel) {
        this.start(channel, null, 0);
    }

    public void start(String channel, String room) {
        this.start(channel, room, 0);
    }

    public void start(String channel, String room, int lastId) {
        this.channel = channel;
        this.room = room;
        this.lastId = lastId;
        if (this.pollRequestLoop == null) {
            this.pollRequestLoop = new PollRequestLoop();
            this.pollRequestLoop.setIsRunning(true);
            new Thread(this.pollRequestLoop).start();
        }
    }

    public void stop() {
        if (this.pollRequestLoop != null) {
            this.pollRequestLoop.setIsRunning(false);
            this.pollRequestLoop = null;
        }
    }

    public ChannelConnectionListener getChannelConnectionListener() {
        return this.channelConnectionListener;
    }

    public void setChannelConnectionListener(ChannelConnectionListener channelConnectionListener) {
        this.channelConnectionListener = channelConnectionListener;
    }

    private void handleSuccess(final Response<Notification> response) {
        if (response.getData() != null) {
            this.lastId = response.getData().getId();
            if (this.channelConnectionListener != null) {
                PlatformType.get().runOnCallbackThread(new Runnable(){

                    @Override
                    public void run() {
                        ChannelConnection.this.channelConnectionListener.onNotification((Notification)response.getData());
                    }
                });
            }
        }
    }

    private void handleError(final Response<Notification> response) {
        if (response.getHttpResultCode() == 504) {
            return;
        }
        if (this.channelConnectionListener != null) {
            PlatformType.get().runOnCallbackThread(new Runnable(){

                @Override
                public void run() {
                    ChannelConnection.this.channelConnectionListener.onError(response);
                }
            });
        }
    }

    private class PollRequestLoop
    implements Runnable {
        private boolean isRunning;

        private PollRequestLoop() {
        }

        public void setIsRunning(boolean isRunning) {
            this.isRunning = isRunning;
        }

        @Override
        public void run() {
            while (this.isRunning) {
                Response responsePollFromChannel = ChannelConnection.this.syncano.pollChannel(ChannelConnection.this.channel, ChannelConnection.this.room, ChannelConnection.this.lastId).send();
                if (!this.isRunning) continue;
                if (responsePollFromChannel.getHttpResultCode() == 204) {
                    ChannelConnection.this.hasError = false;
                }
                if (responsePollFromChannel.getHttpResultCode() == 200) {
                    ChannelConnection.this.handleSuccess(responsePollFromChannel);
                    ChannelConnection.this.hasError = false;
                    continue;
                }
                if (!ChannelConnection.this.hasError) {
                    ChannelConnection.this.handleError(responsePollFromChannel);
                    ChannelConnection.this.hasError = true;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

