/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.simple;

import com.syncano.library.Syncano;
import com.syncano.library.api.FieldsFilter;
import com.syncano.library.api.RequestAll;
import com.syncano.library.api.RequestCount;
import com.syncano.library.api.RequestGetList;
import com.syncano.library.api.Response;
import com.syncano.library.api.ResponseGetList;
import com.syncano.library.api.Where;
import com.syncano.library.callbacks.SyncanoCallback;
import com.syncano.library.choice.FilterType;
import com.syncano.library.choice.SortOrder;
import com.syncano.library.data.SyncanoObject;
import java.util.List;

public class RequestBuilder<T extends SyncanoObject> {
    private Syncano syncano;
    private Class<T> clazz;
    private String sortByField;
    private SortOrder sortOrder;
    private Integer limit;
    private Where<T> where;
    private FieldsFilter fieldsFilter;
    private String pageUrl;
    private String tableView;
    private boolean estimateCount = false;

    public RequestBuilder(Class<T> clazz) {
        this.clazz = clazz;
        this.syncano = Syncano.getInstance();
    }

    public ResponseGetList<T> get() {
        return this.prepareGetRequest().send();
    }

    public ResponseGetList<T> getAll() {
        return new RequestAll<T>(this.prepareGetRequest()).send();
    }

    public void getAll(SyncanoCallback<List<T>> callback) {
        new RequestAll<List<T>>(this.prepareGetRequest()).sendAsync(callback);
    }

    public void get(SyncanoCallback<List<T>> callback) {
        this.prepareGetRequest().sendAsync(callback);
    }

    private RequestGetList<T> prepareGetRequest() {
        RequestGetList<T> request = this.getRequestGetList();
        this.decorateRequest(request);
        return request;
    }

    private RequestGetList<T> getRequestGetList() {
        RequestGetList<T> request = this.pageUrl != null ? this.syncano.getObjects(this.clazz, this.pageUrl) : (this.tableView == null ? this.syncano.getObjects(this.clazz) : this.syncano.getViewObjects(this.clazz, this.tableView));
        return request;
    }

    public Response<T> get(int id) {
        return this.syncano.getObject(this.clazz, id).send();
    }

    public void get(int id, SyncanoCallback<T> callback) {
        this.syncano.getObject(this.clazz, id).sendAsync(callback);
    }

    private void decorateRequest(RequestGetList<T> request) {
        if (this.sortByField != null) {
            request.setOrderBy(this.sortByField, this.sortOrder);
        }
        if (this.limit != null) {
            request.setLimit(this.limit);
        }
        if (this.where != null) {
            request.setWhereFilter(this.where);
        }
        if (this.fieldsFilter != null) {
            request.setFieldsFilter(this.fieldsFilter);
        }
        if (this.estimateCount) {
            request.estimateCount();
        }
    }

    public RequestBuilder<T> on(Syncano syncano) {
        this.syncano = syncano;
        return this;
    }

    public RequestBuilder<T> orderBy(String fieldName) {
        return this.orderBy(fieldName, SortOrder.ASCENDING);
    }

    public RequestBuilder<T> orderBy(String fieldName, SortOrder sortOrder) {
        this.sortByField = fieldName;
        this.sortOrder = sortOrder;
        return this;
    }

    public RequestBuilder<T> selectFields(FilterType filterType, String ... fields) {
        this.fieldsFilter = new FieldsFilter(filterType, fields);
        return this;
    }

    public RequestBuilder<T> selectFields(FilterType filterType, List<String> fields) {
        this.fieldsFilter = new FieldsFilter(filterType, fields);
        return this;
    }

    public RequestBuilder<T> setFieldsFilter(FieldsFilter fieldsFilter) {
        this.fieldsFilter = fieldsFilter;
        return this;
    }

    public RequestBuilder<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public RequestBuilder<T> estimateCount() {
        this.estimateCount = true;
        return this;
    }

    public RequestBuilder<T> page(String pageUrl) {
        this.pageUrl = pageUrl;
        return this;
    }

    public Where<T> where() {
        this.where = new Where(this);
        return this.where;
    }

    public Response<Integer> getCountEstimation() {
        return new RequestCount(this.prepareGetRequest()).send();
    }

    public void getCountEstimation(SyncanoCallback<Integer> callback) {
        new RequestCount(this.prepareGetRequest()).sendAsync(callback);
    }

    public RequestBuilder<T> tableView(String viewName) {
        this.tableView = viewName;
        return this;
    }
}

