/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.data;

import com.syncano.library.Syncano;
import com.syncano.library.annotation.SyncanoField;
import com.syncano.library.api.Response;
import com.syncano.library.callbacks.SyncanoCallback;
import com.syncano.library.choice.SocialAuthBackend;
import com.syncano.library.data.Profile;
import com.syncano.library.data.SyncanoObject;

public abstract class AbstractUser<P extends Profile> {
    public static final String FIELD_ID = "id";
    public static final String FIELD_USER_NAME = "username";
    public static final String FIELD_PASSWORD = "password";
    public static final String FIELD_USER_KEY = "user_key";
    public static final String FIELD_PROFILE = "profile";
    public static final String FIELD_ACCESS_TOKEN = "access_token";
    private Syncano syncano;
    @SyncanoField(name="id", readOnly=true)
    private Integer id;
    @SyncanoField(name="username", required=true)
    private String userName;
    @SyncanoField(name="password", required=true)
    private String password;
    @SyncanoField(name="user_key", readOnly=true)
    private String userKey;
    @SyncanoField(name="profile", readOnly=true)
    private P profile;
    @SyncanoField(name="access_token", required=true)
    private String authToken;
    private SocialAuthBackend socialAuthBackend;

    public AbstractUser() {
    }

    public AbstractUser(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public AbstractUser(SocialAuthBackend socialAuthBackend, String authToken) {
        this.socialAuthBackend = socialAuthBackend;
        this.authToken = authToken;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public P getProfile() {
        return this.profile;
    }

    public void setProfile(P profile) {
        this.profile = profile;
    }

    private Syncano getSyncano() {
        if (this.syncano == null) {
            return Syncano.getInstance();
        }
        return this.syncano;
    }

    public <T extends AbstractUser<P>> T on(Syncano syncano) {
        this.syncano = syncano;
        return (T)this;
    }

    public Response<P> fetchProfile() {
        return ((SyncanoObject)this.getProfile()).fetch();
    }

    public void fetchProfile(SyncanoCallback<P> syncanoCallback) {
        ((SyncanoObject)this.getProfile()).fetch(syncanoCallback);
    }

    public <T extends AbstractUser> Response<T> fetch() {
        return this.getSyncano().fetchCurrentUser(this).send();
    }

    public <T extends AbstractUser> void fetch(SyncanoCallback<T> syncanoCallback) {
        this.getSyncano().fetchCurrentUser(this).sendAsync(syncanoCallback);
    }

    public <T extends AbstractUser> Response<T> register() {
        return this.getSyncano().registerUser(this).send();
    }

    public <T extends AbstractUser> void register(SyncanoCallback<T> callback) {
        this.getSyncano().registerUser(this).sendAsync(callback);
    }

    public <T extends AbstractUser> Response<T> login() {
        return this.getSyncano().loginUser(this).send();
    }

    public <T extends AbstractUser> Response<T> loginSocialUser() {
        return this.getSyncano().loginSocialUser(this).send();
    }

    public <T extends AbstractUser> void loginSocialUser(SyncanoCallback<T> callback) {
        this.getSyncano().loginSocialUser(this).sendAsync(callback);
    }

    public <T extends AbstractUser> void login(SyncanoCallback<T> callback) {
        this.getSyncano().loginUser(this).sendAsync(callback);
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public SocialAuthBackend getSocialAuthBackend() {
        return this.socialAuthBackend;
    }

    public void setSocialAuthBackend(SocialAuthBackend socialAuthBackend) {
        this.socialAuthBackend = socialAuthBackend;
    }
}

