/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.syncano.library.Syncano;
import com.syncano.library.api.RequestGet;
import com.syncano.library.api.Response;
import com.syncano.library.api.ResponseGetList;
import com.syncano.library.api.Where;
import com.syncano.library.choice.SortOrder;
import com.syncano.library.data.PageInternal;
import com.syncano.library.parser.GsonParser;
import java.util.ArrayList;
import java.util.List;

public class RequestGetList<T>
extends RequestGet<List<T>> {
    protected Class<T> resultType;
    private Where where;
    private String orderBy;
    private Integer pageSize;
    private boolean estimateCount;
    private Gson gson;

    public RequestGetList(Class<T> resultType, String url, Syncano syncano) {
        super(url, syncano);
        this.resultType = resultType;
        this.gson = GsonParser.createGson(resultType);
    }

    @Override
    public void prepareUrlParams() {
        super.prepareUrlParams();
        if (this.where != null) {
            this.addUrlParam("query", this.where.buildQuery());
        }
        if (this.orderBy != null) {
            this.addUrlParam("order_by", this.orderBy);
        }
        if (this.pageSize != null) {
            this.addUrlParam("page_size", String.valueOf(this.pageSize));
        }
        if (this.estimateCount) {
            this.addUrlParam("include_count", Boolean.toString(true));
        }
    }

    @Override
    public List<T> parseResult(Response<List<T>> response, String json) {
        PageInternal pageInternal = (PageInternal)this.gson.fromJson(json, PageInternal.class);
        ArrayList<Object> resultList = new ArrayList<Object>();
        List objects = pageInternal.getObjects();
        if (objects != null) {
            for (JsonElement element : objects) {
                resultList.add(this.gson.fromJson(element, this.resultType));
            }
        }
        ResponseGetList r = (ResponseGetList)response;
        r.setNextPageUrl(pageInternal.getNext());
        r.setPreviousPageUrl(pageInternal.getPrev());
        r.setEstimatedCount(pageInternal.getCount());
        return resultList;
    }

    public RequestGetList<T> setWhereFilter(Where where) {
        this.where = where;
        return this;
    }

    public RequestGetList<T> setOrderBy(String fieldName, SortOrder sortOrder) {
        if (fieldName == null || fieldName.length() == 0 || fieldName.startsWith("-")) {
            throw new RuntimeException("Syncano field name can not be empty or begin with character '-'");
        }
        this.orderBy = sortOrder == SortOrder.DESCENDING ? "-" + fieldName : fieldName;
        return this;
    }

    public RequestGetList<T> estimateCount() {
        this.estimateCount = true;
        return this;
    }

    public RequestGetList<T> setLimit(int limit) {
        this.pageSize = limit;
        return this;
    }

    @Override
    public Response<List<T>> instantiateResponse() {
        return new ResponseGetList<T>(this.syncano, this.resultType);
    }

    @Override
    public ResponseGetList<T> send() {
        return (ResponseGetList)super.send();
    }
}

