/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.syncano.library.PlatformType;
import com.syncano.library.Syncano;
import com.syncano.library.api.Response;
import com.syncano.library.callbacks.SyncanoCallback;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class Request<T> {
    private static final ExecutorService requestExecutor = Executors.newFixedThreadPool(3);
    protected Syncano syncano;
    private RunAfter<T> runAfter;

    public Request(Syncano syncano) {
        this.syncano = syncano;
    }

    public RunAfter<T> getRunAfter() {
        return this.runAfter;
    }

    public void setRunAfter(RunAfter<T> runAfter) {
        this.runAfter = runAfter;
    }

    public Response<T> instantiateResponse() {
        return new Response();
    }

    public abstract Response<T> send();

    public void sendAsync(final SyncanoCallback<T> callback) {
        requestExecutor.execute(new Runnable(){

            @Override
            public void run() {
                final Response response = Request.this.send();
                PlatformType.get().runOnCallbackThread(new Runnable(){

                    @Override
                    public void run() {
                        if (response.isSuccess()) {
                            callback.success(response, response.getData());
                        } else {
                            callback.failure(response);
                        }
                    }
                });
            }
        });
    }

    public static interface RunAfter<T> {
        public void run(Response<T> var1);
    }
}

