/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.utils;

import com.google.gson.JsonSyntaxException;
import com.syncano.library.api.HttpRequest;
import com.syncano.library.api.Response;
import com.syncano.library.utils.Encryption;
import com.syncano.library.utils.HttpPatch;
import com.syncano.library.utils.SyncanoLog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class SyncanoHttpClient {
    private static final String LOG_TAG = SyncanoHttpClient.class.getSimpleName();
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_PATCH = "PATCH";
    public static final String METHOD_DELETE = "DELETE";
    private static final int NOT_SET = -1;
    private int timeout = -1;

    public void setTimeout(int millis) {
        this.timeout = millis;
    }

    public <T> Response<T> send(HttpRequest<T> syncanoRequest) {
        HttpResponse response;
        HttpEntity parameters = syncanoRequest.prepareParams();
        String url = syncanoRequest.getUrl();
        HttpUriRequest request = this.getHttpUriRequest(syncanoRequest.getRequestMethod(), url, parameters);
        request.setHeader("Content-Type", syncanoRequest.getContentType());
        request.setHeader("Accept-Encoding", "gzip");
        for (NameValuePair header : syncanoRequest.getHttpHeaders()) {
            request.setHeader(header.getName(), header.getValue());
        }
        DefaultHttpClient httpclient = Encryption.getHttpClient();
        httpclient.getParams().setParameter("http.useragent", (Object)"syncano-android-4.0.6");
        HttpParams httpParameters = httpclient.getParams();
        if (this.timeout != -1) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)(this.timeout * 1000));
            HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)(this.timeout * 1000));
        }
        Response<T> syncanoResponse = syncanoRequest.instantiateResponse();
        try {
            response = httpclient.execute(request);
        }
        catch (ClientProtocolException e) {
            SyncanoLog.w(LOG_TAG, "ClientProtocolException");
            syncanoResponse.setResultCode(2);
            syncanoResponse.setError(e.toString());
            return syncanoResponse;
        }
        catch (IOException e) {
            SyncanoLog.w(LOG_TAG, "IOException");
            syncanoResponse.setResultCode(4);
            syncanoResponse.setError(e.toString());
            return syncanoResponse;
        }
        try {
            syncanoResponse.setHttpResultCode(response.getStatusLine().getStatusCode());
            syncanoResponse.setHttpReasonPhrase(response.getStatusLine().getReasonPhrase());
            String json = null;
            if (response.getEntity() != null) {
                byte[] data;
                InputStream is = response.getEntity().getContent();
                Header contentEncoding = response.getFirstHeader("Content-Encoding");
                if (contentEncoding != null && contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                    is = new GZIPInputStream(is);
                }
                if ((data = SyncanoHttpClient.readToByteArray(is)) != null) {
                    json = new String(data);
                }
            }
            if (syncanoRequest.isCorrectHttpResponseCode(response.getStatusLine().getStatusCode())) {
                syncanoResponse.setData(syncanoRequest.parseResult(syncanoResponse, json));
            } else {
                syncanoResponse.setResultCode(1);
                syncanoResponse.setError("Http error.");
                if (json != null) {
                    syncanoResponse.setError(json);
                }
            }
        }
        catch (IllegalStateException e) {
            SyncanoLog.w(LOG_TAG, "IllegalStateException");
            syncanoResponse.setResultCode(3);
            syncanoResponse.setError(e.toString());
            return syncanoResponse;
        }
        catch (JsonSyntaxException e) {
            SyncanoLog.w(LOG_TAG, "JsonSyntaxException");
            syncanoResponse.setResultCode(5);
            syncanoResponse.setError("Error parsing response. " + e.toString());
            return syncanoResponse;
        }
        catch (IOException e) {
            SyncanoLog.w(LOG_TAG, "IOException");
            syncanoResponse.setResultCode(4);
            syncanoResponse.setError(e.toString());
            return syncanoResponse;
        }
        return syncanoResponse;
    }

    private HttpUriRequest getHttpUriRequest(String requestMethod, String url, HttpEntity postData) {
        if (METHOD_GET.equals(requestMethod)) {
            return new HttpGet(url);
        }
        if (METHOD_POST.equals(requestMethod)) {
            HttpPost httpPost = new HttpPost(url);
            if (postData != null) {
                httpPost.setEntity(postData);
            }
            return httpPost;
        }
        if (METHOD_PUT.equals(requestMethod)) {
            HttpPut httpPut = new HttpPut(url);
            if (postData != null) {
                httpPut.setEntity(postData);
            }
            return httpPut;
        }
        if (METHOD_PATCH.equals(requestMethod)) {
            HttpPatch httpPatch = new HttpPatch(url);
            if (postData != null) {
                httpPatch.setEntity(postData);
            }
            return httpPatch;
        }
        if (METHOD_DELETE.equals(requestMethod)) {
            return new HttpDelete(url);
        }
        return new HttpGet(url);
    }

    private static byte[] readToByteArray(InputStream is) throws IOException {
        int s;
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((s = is.read(buffer)) != -1) {
            baos.write(buffer, 0, s);
        }
        return baos.toByteArray();
    }
}

