/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.data;

import com.google.gson.JsonObject;
import com.syncano.library.Syncano;
import com.syncano.library.annotation.SyncanoField;
import com.syncano.library.api.Response;
import com.syncano.library.callbacks.SyncanoCallback;
import com.syncano.library.data.Trace;
import com.syncano.library.utils.SyncanoLog;

public class Webhook {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_CODEBOX = "codebox";
    public static final String FIELD_PUBLIC = "public";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_LINKS = "links";
    @SyncanoField(name="name", readOnly=true, required=true)
    private String name;
    @SyncanoField(name="codebox", required=true)
    private int codebox;
    @SyncanoField(name="public")
    private boolean isPublic = false;
    @SyncanoField(name="description")
    private String description;
    @SyncanoField(name="links", readOnly=true)
    private WebHookLinks links;
    private Trace trace;
    private Object customResponse;
    private Syncano syncano;

    public Webhook() {
    }

    public Webhook(String name) {
        this.name = name;
    }

    public Webhook(String name, int codebox) {
        this.name = name;
        this.codebox = codebox;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getCodebox() {
        return this.codebox;
    }

    public void setCodebox(int codebox) {
        this.codebox = codebox;
    }

    public String getPublicLink() {
        if (this.links == null || this.links.publicLink == null) {
            return null;
        }
        if (this.getSyncano() != null) {
            return this.getSyncano().getUrl() + this.links.publicLink;
        }
        return "https://api.syncano.io" + this.links.publicLink;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WebHookLinks getLinks() {
        return this.links;
    }

    public void setLinks(WebHookLinks links) {
        this.links = links;
    }

    private Syncano getSyncano() {
        if (this.syncano == null) {
            return Syncano.getInstance();
        }
        return this.syncano;
    }

    public Webhook on(Syncano syncano) {
        this.syncano = syncano;
        return this;
    }

    public String getOutput() {
        if (this.trace != null) {
            return this.trace.getOutput();
        }
        SyncanoLog.d(Webhook.class.getSimpleName(), "Getting output, without calling run() first");
        return null;
    }

    public String getErrorOutput() {
        if (this.trace != null) {
            return this.trace.getErrorOutput();
        }
        SyncanoLog.d(Webhook.class.getSimpleName(), "Getting output, without calling run() first");
        return null;
    }

    public Response<Trace> run() {
        return this.getSyncano().runWebhook(this).send();
    }

    public Response<Trace> run(JsonObject payload) {
        return this.getSyncano().runWebhook(this, payload).send();
    }

    public void run(SyncanoCallback<Trace> callback) {
        this.getSyncano().runWebhook(this).sendAsync(callback);
    }

    public void run(JsonObject payload, SyncanoCallback<Trace> callback) {
        this.getSyncano().runWebhook(this, payload).sendAsync(callback);
    }

    public Response<String> runCustomResponse() {
        return this.getSyncano().runWebhookCustomResponse(this).send();
    }

    public <T> Response<T> runCustomResponse(Class<T> type) {
        return this.getSyncano().runWebhookCustomResponse(this, type).send();
    }

    public Response<String> runCustomResponse(JsonObject payload) {
        return this.getSyncano().runWebhookCustomResponse(this, payload).send();
    }

    public <T> Response<T> runCustomResponse(Class<T> type, JsonObject payload) {
        return this.getSyncano().runWebhookCustomResponse(this, type, payload).send();
    }

    public void runCustomResponse(SyncanoCallback<String> callback) {
        this.getSyncano().runWebhookCustomResponse(this).sendAsync(callback);
    }

    public <T> void runCustomResponse(Class<T> type, SyncanoCallback<T> callback) {
        this.getSyncano().runWebhookCustomResponse(this, type).sendAsync(callback);
    }

    public void runCustomResponse(JsonObject payload, SyncanoCallback<String> callback) {
        this.getSyncano().runWebhookCustomResponse(this, payload).sendAsync(callback);
    }

    public <T> void runCustomResponse(Class<T> type, JsonObject payload, SyncanoCallback<T> callback) {
        this.getSyncano().runWebhookCustomResponse(this, type, payload).sendAsync(callback);
    }

    public Trace getTrace() {
        return this.trace;
    }

    public void setTrace(Trace trace) {
        this.trace = trace;
    }

    public <T> T getCustomResponse() {
        return (T)this.customResponse;
    }

    public void setCustomResponse(Object customResponse) {
        this.customResponse = customResponse;
    }

    public static class WebHookLinks {
        @SyncanoField(name="reset-link")
        public String resetLink;
        @SyncanoField(name="codebox")
        public String codebox;
        @SyncanoField(name="run")
        public String run;
        @SyncanoField(name="public-link")
        public String publicLink;
        @SyncanoField(name="self")
        public String self;
        @SyncanoField(name="traces")
        public String traces;
    }
}

