/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.syncano.library.Syncano;
import com.syncano.library.api.RequestGetList;
import com.syncano.library.api.Response;
import com.syncano.library.callbacks.SyncanoCallback;
import java.util.List;

public class ResponseGetList<T>
extends Response<List<T>> {
    private String previousPageUrl;
    private String nextPageUrl;
    private Integer estimatedCount;
    private Syncano syncano;
    private Class<T> resultType;

    public ResponseGetList(Syncano syncano, Class<T> resultType) {
        this.syncano = syncano;
        this.resultType = resultType;
    }

    public String getPreviousPageUrl() {
        return this.previousPageUrl;
    }

    public void setPreviousPageUrl(String previousPageUrl) {
        this.previousPageUrl = previousPageUrl;
    }

    public String getNextPageUrl() {
        return this.nextPageUrl;
    }

    public void setNextPageUrl(String nextPageUrl) {
        this.nextPageUrl = nextPageUrl;
    }

    public boolean hasNextPage() {
        return this.nextPageUrl != null && !this.nextPageUrl.isEmpty();
    }

    public boolean hasPreviousPage() {
        return this.previousPageUrl != null && !this.previousPageUrl.isEmpty();
    }

    public RequestGetList<T> getNextPageRequest() {
        return new RequestGetList<T>(this.resultType, this.nextPageUrl, this.syncano);
    }

    public RequestGetList<T> getPreviousPageRequest() {
        return new RequestGetList<T>(this.resultType, this.previousPageUrl, this.syncano);
    }

    public ResponseGetList<T> getNextPage() {
        return this.getNextPageRequest().send();
    }

    public void getNextPage(SyncanoCallback<List<T>> callback) {
        this.getNextPageRequest().sendAsync(callback);
    }

    public ResponseGetList<T> getPreviousPage() {
        return this.getPreviousPageRequest().send();
    }

    public void getPreviousPage(SyncanoCallback<List<T>> callback) {
        this.getPreviousPageRequest().sendAsync(callback);
    }

    public void setEstimatedCount(Integer count) {
        this.estimatedCount = count;
    }

    public Integer getEstimatedCount() {
        return this.estimatedCount;
    }
}

