/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library;

import android.content.Context;
import com.google.gson.JsonObject;
import com.syncano.library.Syncano;
import com.syncano.library.api.Request;
import com.syncano.library.api.RequestDelete;
import com.syncano.library.api.RequestGetList;
import com.syncano.library.api.RequestGetOne;
import com.syncano.library.api.RequestPatch;
import com.syncano.library.api.RequestPost;
import com.syncano.library.api.Response;
import com.syncano.library.data.AbstractUser;
import com.syncano.library.data.Channel;
import com.syncano.library.data.CodeBox;
import com.syncano.library.data.Group;
import com.syncano.library.data.GroupMembership;
import com.syncano.library.data.SyncanoClass;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.data.SyncanoTableView;
import com.syncano.library.data.User;
import com.syncano.library.data.Webhook;
import com.syncano.library.utils.SyncanoClassHelper;
import com.syncano.library.utils.Validate;

public class SyncanoDashboard
extends Syncano {
    public SyncanoDashboard() {
    }

    public SyncanoDashboard(String instanceName) {
        super(instanceName);
    }

    public SyncanoDashboard(String apiKey, String instanceName) {
        super(apiKey, instanceName);
    }

    public SyncanoDashboard(String apiKey, String instanceName, Context androidContext) {
        super(apiKey, instanceName, androidContext);
    }

    public SyncanoDashboard(String customServerUrl, String apiKey, String instanceName) {
        super(customServerUrl, apiKey, instanceName);
    }

    public SyncanoDashboard(String customServerUrl, String apiKey, String instanceName, Context androidContext) {
        super(customServerUrl, apiKey, instanceName, androidContext);
    }

    public RequestPost<CodeBox> createCodeBox(CodeBox codeBox) {
        String url = String.format("/v1/instances/%s/codeboxes/", this.getNotEmptyInstanceName());
        return new RequestPost<CodeBox>(CodeBox.class, url, this, codeBox);
    }

    public RequestGetOne<CodeBox> getCodeBox(int id) {
        String url = String.format("/v1/instances/%s/codeboxes/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestGetOne<Class<CodeBox>>(CodeBox.class, url, (Syncano)this);
    }

    public RequestGetList<CodeBox> getCodeBoxes() {
        String url = String.format("/v1/instances/%s/codeboxes/", this.getNotEmptyInstanceName());
        return new RequestGetList<CodeBox>(CodeBox.class, url, this);
    }

    public RequestPatch<CodeBox> updateCodeBox(CodeBox codeBox) {
        Validate.checkNotNullAndZero(codeBox.getId(), "Trying to update object without id!");
        String url = String.format("/v1/instances/%s/codeboxes/%d/", this.getNotEmptyInstanceName(), codeBox.getId());
        return new RequestPatch<CodeBox>(CodeBox.class, url, this, codeBox);
    }

    public RequestDelete<CodeBox> deleteCodeBox(int id) {
        String url = String.format("/v1/instances/%s/codeboxes/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestDelete<CodeBox>(CodeBox.class, url, this);
    }

    public RequestPost<Webhook> createWebhook(final Webhook webhook) {
        String url = String.format("/v1/instances/%s/webhooks/", this.getNotEmptyInstanceName());
        RequestPost<Webhook> req = new RequestPost<Webhook>(Webhook.class, url, this, webhook);
        req.updateGivenObject(true);
        req.setRunAfter(new Request.RunAfter<Webhook>(){

            @Override
            public void run(Response<Webhook> response) {
                webhook.on(SyncanoDashboard.this);
            }
        });
        return req;
    }

    public RequestGetOne<Webhook> getWebhook(String name) {
        String url = String.format("/v1/instances/%s/webhooks/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestGetOne<Class<Webhook>>(Webhook.class, url, (Syncano)this);
    }

    public RequestGetList<Webhook> getWebhooks() {
        String url = String.format("/v1/instances/%s/webhooks/", this.getNotEmptyInstanceName());
        return new RequestGetList<Webhook>(Webhook.class, url, this);
    }

    public RequestPatch<Webhook> updateWebhook(Webhook webhook) {
        Validate.checkNotNullAndNotEmpty(webhook.getName(), "Trying to update Webhook without name!");
        String url = String.format("/v1/instances/%s/webhooks/%s/", this.getNotEmptyInstanceName(), webhook.getName());
        return new RequestPatch<Webhook>(Webhook.class, url, this, webhook);
    }

    public RequestDelete<Webhook> deleteWebhook(String name) {
        String url = String.format("/v1/instances/%s/webhooks/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestDelete<Webhook>(Webhook.class, url, this);
    }

    public RequestPost<SyncanoClass> createSyncanoClass(SyncanoClass clazz) {
        String url = String.format("/v1/instances/%s/classes/", this.getNotEmptyInstanceName());
        return new RequestPost<SyncanoClass>(SyncanoClass.class, url, this, clazz);
    }

    public RequestPost<SyncanoTableView> createTableView(SyncanoTableView clazz) {
        String url = String.format("/v1/instances/%s/api/objects/", this.getNotEmptyInstanceName());
        return new RequestPost<SyncanoTableView>(SyncanoTableView.class, url, this, clazz);
    }

    public RequestDelete<SyncanoTableView> deleteTableView(String name) {
        String url = String.format("/v1/instances/%s/api/objects/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestDelete<SyncanoTableView>(SyncanoTableView.class, url, this);
    }

    public RequestPost<SyncanoClass> createSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.createSyncanoClass(new SyncanoClass(clazz));
    }

    public RequestGetOne<SyncanoClass> getSyncanoClass(String name) {
        String url = String.format("/v1/instances/%s/classes/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestGetOne<Class<SyncanoClass>>(SyncanoClass.class, url, (Syncano)this);
    }

    public RequestGetOne<SyncanoClass> getSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.getSyncanoClass(SyncanoClassHelper.getSyncanoClassName(clazz));
    }

    public RequestGetList<SyncanoClass> getSyncanoClasses() {
        String url = String.format("/v1/instances/%s/classes/", this.getNotEmptyInstanceName());
        return new RequestGetList<SyncanoClass>(SyncanoClass.class, url, this);
    }

    public RequestPatch<SyncanoClass> updateSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.updateSyncanoClass(new SyncanoClass(clazz));
    }

    public RequestPatch<SyncanoClass> updateSyncanoClass(SyncanoClass clazz) {
        Validate.checkNotNullAndNotEmpty(clazz.getName(), "Trying to update SyncanoClass without giving name!");
        String url = String.format("/v1/instances/%s/classes/%s/", this.getNotEmptyInstanceName(), clazz.getName());
        return new RequestPatch<SyncanoClass>(SyncanoClass.class, url, this, clazz);
    }

    public RequestDelete<SyncanoClass> deleteSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.deleteSyncanoClass(SyncanoClassHelper.getSyncanoClassName(clazz));
    }

    public RequestDelete<SyncanoClass> deleteSyncanoClass(String name) {
        String url = String.format("/v1/instances/%s/classes/%s/", this.getNotEmptyInstanceName(), name);
        return new RequestDelete<SyncanoClass>(SyncanoClass.class, url, this);
    }

    public RequestDelete<User> deleteUser(int id) {
        return this.deleteUser(User.class, id);
    }

    public <T extends AbstractUser> RequestDelete<T> deleteUser(Class<T> type, int id) {
        String url = String.format("/v1/instances/%s/users/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestDelete<T>(type, url, this);
    }

    public RequestPost<Group> createGroup(Group group) {
        String url = String.format("/v1/instances/%s/groups/", this.getNotEmptyInstanceName());
        return new RequestPost<Group>(Group.class, url, this, group);
    }

    public RequestGetOne<Group> getGroup(int id) {
        String url = String.format("/v1/instances/%s/groups/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestGetOne<Class<Group>>(Group.class, url, (Syncano)this);
    }

    public RequestGetList<Group> getGroups() {
        String url = String.format("/v1/instances/%s/groups/", this.getNotEmptyInstanceName());
        return new RequestGetList<Group>(Group.class, url, this);
    }

    public RequestPatch<Group> updateGroup(Group group) {
        Validate.checkNotNullAndZero(group.getId(), "Trying to update Group without id!");
        String url = String.format("/v1/instances/%s/groups/%d/", this.getNotEmptyInstanceName(), group.getId());
        return new RequestPatch<Group>(Group.class, url, this, group);
    }

    public RequestDelete<Group> deleteGroup(int id) {
        String url = String.format("/v1/instances/%s/groups/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestDelete<Group>(Group.class, url, this);
    }

    public RequestGetOne<GroupMembership> getGroupMembership(int groupId, int userId) {
        String url = String.format("/v1/instances/%s/groups/%d/users/%d/", this.getNotEmptyInstanceName(), groupId, userId);
        return new RequestGetOne<Class<GroupMembership>>(GroupMembership.class, url, (Syncano)this);
    }

    public RequestGetList<GroupMembership> getGroupMemberships(int groupId) {
        String url = String.format("/v1/instances/%s/groups/%d/users/", this.getNotEmptyInstanceName(), groupId);
        return new RequestGetList<GroupMembership>(GroupMembership.class, url, this);
    }

    public RequestPost<GroupMembership> addUserToGroup(int groupId, int userId) {
        String url = String.format("/v1/instances/%s/groups/%d/users/", this.getNotEmptyInstanceName(), groupId);
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("user", (Number)userId);
        return new RequestPost<GroupMembership>(GroupMembership.class, url, this, jsonParams);
    }

    public RequestDelete<GroupMembership> deleteUserFromGroup(int groupId, int userId) {
        String url = String.format("/v1/instances/%s/groups/%d/users/%d/", this.getNotEmptyInstanceName(), groupId, userId);
        return new RequestDelete<GroupMembership>(GroupMembership.class, url, this);
    }

    public RequestPost<Channel> createChannel(Channel channel) {
        String url = String.format("/v1/instances/%s/channels/", this.getNotEmptyInstanceName());
        return new RequestPost<Channel>(Channel.class, url, this, channel);
    }

    public RequestGetOne<Channel> getChannel(String channelName) {
        String url = String.format("/v1/instances/%s/channels/%s/", this.getNotEmptyInstanceName(), channelName);
        return new RequestGetOne<Class<Channel>>(Channel.class, url, (Syncano)this);
    }

    public RequestGetList<Channel> getChannels() {
        String url = String.format("/v1/instances/%s/channels/", this.getNotEmptyInstanceName());
        return new RequestGetList<Channel>(Channel.class, url, this);
    }

    public RequestPatch<Channel> updateChannel(Channel channel) {
        Validate.checkNotNullAndNotEmpty(channel.getName(), "Trying to update Channel without name!");
        String url = String.format("/v1/instances/%s/channels/%s/", this.getNotEmptyInstanceName(), channel.getName());
        return new RequestPatch<Channel>(Channel.class, url, this, channel);
    }

    public RequestDelete<Channel> deleteChannel(String channelName) {
        String url = String.format("/v1/instances/%s/channels/%s/", this.getNotEmptyInstanceName(), channelName);
        return new RequestDelete<Channel>(Channel.class, url, this);
    }

    public RequestGetList<User> getUsers() {
        return this.getUsers(User.class);
    }

    public <T extends AbstractUser> RequestGetList<T> getUsers(Class<T> type) {
        String url = String.format("/v1/instances/%s/users/", this.getNotEmptyInstanceName());
        return new RequestGetList<T>(type, url, this);
    }
}

