/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library;

import android.content.Context;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syncano.library.api.HttpRequest;
import com.syncano.library.api.IncrementBuilder;
import com.syncano.library.api.Request;
import com.syncano.library.api.RequestDelete;
import com.syncano.library.api.RequestGet;
import com.syncano.library.api.RequestGetList;
import com.syncano.library.api.RequestGetOne;
import com.syncano.library.api.RequestPatch;
import com.syncano.library.api.RequestPost;
import com.syncano.library.api.Response;
import com.syncano.library.choice.SocialAuthBackend;
import com.syncano.library.data.AbstractUser;
import com.syncano.library.data.CodeBox;
import com.syncano.library.data.Notification;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.data.Trace;
import com.syncano.library.data.User;
import com.syncano.library.data.Webhook;
import com.syncano.library.simple.RequestBuilder;
import com.syncano.library.utils.Encryption;
import com.syncano.library.utils.SyncanoClassHelper;
import com.syncano.library.utils.UserMemory;
import com.syncano.library.utils.Validate;

public class Syncano {
    private static Syncano sharedInstance = null;
    protected String customServerUrl;
    protected String apiKey;
    protected AbstractUser user;
    protected String instanceName;
    private Context androidContext = null;

    public Syncano() {
        this(null, null);
    }

    public Syncano(String instanceName) {
        this(null, instanceName);
    }

    public Syncano(String apiKey, String instanceName) {
        this(null, apiKey, instanceName);
    }

    public Syncano(String apiKey, String instanceName, Context androidContext) {
        this(null, apiKey, instanceName, androidContext);
    }

    public Syncano(String customServerUrl, String apiKey, String instanceName) {
        this(customServerUrl, apiKey, instanceName, null);
    }

    public Syncano(String customServerUrl, String apiKey, String instanceName, Context androidContext) {
        this.customServerUrl = customServerUrl;
        this.apiKey = apiKey;
        this.instanceName = instanceName;
        this.androidContext = androidContext;
        this.user = UserMemory.getUserFromStorage(this);
    }

    public static Syncano init(String customServerUrl, String apiKey, String instanceName, Context androidContext) {
        sharedInstance = new Syncano(customServerUrl, apiKey, instanceName, androidContext);
        return sharedInstance;
    }

    public static Syncano init(String customServerUrl, String apiKey, String instanceName) {
        return Syncano.init(customServerUrl, apiKey, instanceName, null);
    }

    public static Syncano init(String apiKey, String instanceName, Context androidContext) {
        return Syncano.init(null, apiKey, instanceName, androidContext);
    }

    public static Syncano init(String apiKey, String instanceName) {
        return Syncano.init(null, apiKey, instanceName);
    }

    public static void setStrictCheckCertificate(boolean strictCheck) {
        Encryption.setStrictCheckCertificate(strictCheck);
    }

    public static Syncano getInstance() {
        return sharedInstance;
    }

    public static void setInstance(Syncano syncano) {
        sharedInstance = syncano;
    }

    public static <T extends SyncanoObject> RequestBuilder<T> please(Class<T> clazz) {
        return new RequestBuilder<T>(clazz);
    }

    public String getUrl() {
        if (this.customServerUrl != null && !this.customServerUrl.isEmpty()) {
            return this.customServerUrl;
        }
        return "https://api.syncano.io";
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getNotEmptyInstanceName() {
        if (this.instanceName == null || this.instanceName.isEmpty()) {
            throw new RuntimeException("Syncano instance name is not set");
        }
        return this.instanceName;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getNotEmptyApiKey() {
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            throw new RuntimeException("Syncano api key is not set");
        }
        return this.apiKey;
    }

    public String getUserKey() {
        if (this.user == null) {
            return null;
        }
        return this.user.getUserKey();
    }

    public AbstractUser getUser() {
        return this.user;
    }

    public void setUser(AbstractUser user) {
        this.user = user;
        UserMemory.saveUserToStorage(this, user);
    }

    public Context getAndroidContext() {
        return this.androidContext;
    }

    public void setAndroidContext(Context ctx) {
        this.androidContext = ctx;
    }

    public <T extends SyncanoObject> RequestPost<T> createObject(T object) {
        return this.createObject(object, false);
    }

    public <T extends SyncanoObject> RequestPost<T> createObject(T object, boolean updateGivenObject) {
        Class<?> type = object.getClass();
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/", this.getNotEmptyInstanceName(), className);
        RequestPost req = new RequestPost(type, url, this, object);
        req.updateGivenObject(updateGivenObject);
        return req;
    }

    public <T extends SyncanoObject> RequestGetOne<T> getObject(Class<T> type, int id) {
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/%d/", this.getNotEmptyInstanceName(), className, id);
        return new RequestGetOne<Class<T>>(type, url, this);
    }

    public <T extends SyncanoObject> RequestGetOne<T> getObject(T object) {
        Validate.checkNotNullAndZero(object.getId(), "Can't fetch object without id");
        String className = SyncanoClassHelper.getSyncanoClassName(object.getClass());
        String url = String.format("/v1/instances/%s/classes/%s/objects/%d/", this.getNotEmptyInstanceName(), className, object.getId());
        return new RequestGetOne<T>(object, url, this);
    }

    public <T extends SyncanoObject> RequestGetList<T> getViewObjects(Class<T> type, String tableView) {
        String url = String.format("/v1/instances/%s/api/objects/%s/get/", this.getNotEmptyInstanceName(), tableView);
        return new RequestGetList<T>(type, url, this);
    }

    public <T extends SyncanoObject> RequestGetList<T> getObjects(Class<T> type) {
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/", this.getNotEmptyInstanceName(), className);
        return new RequestGetList<T>(type, url, this);
    }

    public <T extends SyncanoObject> RequestGetList<T> getObjects(Class<T> type, String pageUrl) {
        return new RequestGetList<T>(type, pageUrl, this);
    }

    public <T extends SyncanoObject> RequestPatch<T> updateObject(T object) {
        return this.updateObject(object, false);
    }

    public <T extends SyncanoObject> RequestPatch<T> updateObject(T object, boolean updateGivenObject) {
        Validate.checkNotNullAndZero(object.getId(), "Trying to update object without id!");
        Class<?> type = object.getClass();
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/%d/", this.getNotEmptyInstanceName(), className, object.getId());
        RequestPatch req = new RequestPatch(type, url, this, object);
        req.updateGivenObject(updateGivenObject);
        return req;
    }

    public <T extends SyncanoObject> RequestPatch<T> addition(T object, IncrementBuilder incrementBuilder) {
        Validate.checkNotNullAndZero(object.getId(), "Can't addition field object without id");
        return this.addition(object.getClass(), object.getId(), incrementBuilder);
    }

    public <T extends SyncanoObject> RequestPatch<T> addition(Class<T> type, int id, IncrementBuilder incrementBuilder) {
        if (incrementBuilder.hasAdditionFields()) {
            throw new IllegalArgumentException("Cannot create increment query without specify fields to increment/decrement!");
        }
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/%d/", this.getNotEmptyInstanceName(), className, id);
        JsonObject additionQuery = new JsonObject();
        incrementBuilder.build(additionQuery);
        return new RequestPatch<T>(type, url, this, additionQuery);
    }

    public <T extends SyncanoObject> RequestDelete<T> deleteObject(Class<T> type, int id) {
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/%d/", this.getNotEmptyInstanceName(), className, id);
        return new RequestDelete<T>(type, url, this);
    }

    public <T extends SyncanoObject> RequestDelete<T> deleteObject(T object) {
        Validate.checkNotNullAndZero(object.getId(), "Can't delete object without id");
        return this.deleteObject(object.getClass(), object.getId());
    }

    public RequestPost<Trace> runCodeBox(int id) {
        return this.runCodeBox(id, null);
    }

    public RequestPost<Trace> runCodeBox(int id, JsonObject params) {
        String url = String.format("/v1/instances/%s/codeboxes/%d/run/", this.getNotEmptyInstanceName(), id);
        JsonObject payload = new JsonObject();
        payload.add("payload", (JsonElement)params);
        RequestPost<Trace> req = new RequestPost<Trace>(Trace.class, url, this, payload);
        this.addCodeboxIdAfterCall(req, id);
        return req;
    }

    public RequestPost<Trace> runCodeBox(CodeBox codeBox) {
        return this.runCodeBox(codeBox, null);
    }

    public RequestPost<Trace> runCodeBox(final CodeBox codeBox, JsonObject params) {
        Validate.checkNotNullAndZero(codeBox.getId(), "Can't run codebox without giving it's id");
        RequestPost<Trace> req = this.runCodeBox(codeBox.getId(), params);
        req.setRunAfter(new Request.RunAfter<Trace>(){

            @Override
            public void run(Response<Trace> response) {
                Trace trace = response.getData();
                if (trace == null) {
                    return;
                }
                trace.setCodeBoxId(codeBox.getId());
                codeBox.setTrace(trace);
            }
        });
        return req;
    }

    public RequestGet<Trace> getTrace(int codeboxId, int traceId) {
        String url = String.format("/v1/instances/%s/codeboxes/%d/traces/%d/", this.getNotEmptyInstanceName(), codeboxId, traceId);
        RequestGetOne<Class<Trace>> req = new RequestGetOne<Class<Trace>>(Trace.class, url, this);
        this.addCodeboxIdAfterCall(req, codeboxId);
        return req;
    }

    public RequestGet<Trace> getTrace(Trace trace) {
        Validate.checkNotNullAndZero(trace.getCodeBoxId(), "Fetching trace result without codebox id. If run from webhook, result is already known.");
        String url = String.format("/v1/instances/%s/codeboxes/%d/traces/%d/", this.getNotEmptyInstanceName(), trace.getCodeBoxId(), trace.getId());
        return new RequestGetOne<Trace>(trace, url, this);
    }

    private void addCodeboxIdAfterCall(HttpRequest<Trace> req, final int codeboxId) {
        req.setRunAfter(new Request.RunAfter<Trace>(){

            @Override
            public void run(Response<Trace> response) {
                Trace trace = response.getData();
                if (trace != null) {
                    trace.setCodeBoxId(codeboxId);
                }
            }
        });
    }

    public RequestPost<Trace> runWebhook(String name) {
        return this.runWebhook(name, null);
    }

    public RequestPost<String> runWebhookCustomResponse(String name) {
        return this.runWebhookCustomResponse(name, String.class);
    }

    public <T> RequestPost<T> runWebhookCustomResponse(String name, Class<T> type) {
        return this.runWebhookCustomResponse(name, type, null);
    }

    public RequestPost<Trace> runWebhook(String name, JsonObject payload) {
        return this.runWebhookCustomResponse(name, Trace.class, payload);
    }

    public RequestPost<String> runWebhookCustomResponse(String name, JsonObject payload) {
        return this.runWebhookCustomResponse(name, String.class, payload);
    }

    public <T> RequestPost<T> runWebhookCustomResponse(String name, Class<T> type, JsonObject payload) {
        String url = String.format("/v1/instances/%s/webhooks/%s/run/", this.getNotEmptyInstanceName(), name);
        return new RequestPost<T>(type, url, this, payload);
    }

    public RequestPost<Trace> runWebhook(Webhook webhook) {
        return this.runWebhook(webhook, null);
    }

    public RequestPost<String> runWebhookCustomResponse(Webhook webhook) {
        return this.runWebhookCustomResponse(webhook, String.class);
    }

    public <T> RequestPost<T> runWebhookCustomResponse(Webhook webhook, Class<T> type) {
        return this.runWebhookCustomResponse(webhook, type, null);
    }

    public RequestPost<Trace> runWebhook(Webhook webhook, JsonObject payload) {
        return this.runWebhookCustomResponse(webhook, Trace.class, payload);
    }

    public RequestPost<String> runWebhookCustomResponse(Webhook webhook, JsonObject payload) {
        return this.runWebhookCustomResponse(webhook, String.class, payload);
    }

    public <T> RequestPost<T> runWebhookCustomResponse(final Webhook webhook, final Class<T> type, JsonObject payload) {
        Validate.checkNotNullAndNotEmpty(webhook.getName(), "Can't run webhook without a name.");
        RequestPost<T> req = this.runWebhookCustomResponse(webhook.getName(), type, payload);
        req.setRunAfter(new Request.RunAfter<T>(){

            @Override
            public void run(Response<T> response) {
                if (type.equals(Trace.class)) {
                    webhook.setTrace((Trace)response.getData());
                } else {
                    webhook.setCustomResponse(response.getData());
                }
            }
        });
        return req;
    }

    public RequestPost<Trace> runWebhookUrl(String url) {
        return this.runWebhookUrl(url, null);
    }

    public RequestPost<String> runWebhookUrlCustomResponse(String url) {
        return this.runWebhookUrlCustomResponse(url, String.class);
    }

    public <T> RequestPost<T> runWebhookUrlCustomResponse(String url, Class<T> type) {
        return this.runWebhookUrlCustomResponse(url, type, null);
    }

    public RequestPost<Trace> runWebhookUrl(String url, JsonObject payload) {
        return this.runWebhookUrlCustomResponse(url, Trace.class, payload);
    }

    public RequestPost<String> runWebhookUrlCustomResponse(String url, JsonObject payload) {
        return this.runWebhookUrlCustomResponse(url, String.class, payload);
    }

    public <T> RequestPost<T> runWebhookUrlCustomResponse(String url, Class<T> type, JsonObject payload) {
        RequestPost<T> req = new RequestPost<T>(type, null, this, payload);
        req.setCompleteCustomUrl(url);
        return req;
    }

    public <T extends AbstractUser> RequestPost<T> registerUser(T user) {
        Class<?> type = user.getClass();
        String url = String.format("/v1/instances/%s/users/", this.getNotEmptyInstanceName());
        RequestPost req = new RequestPost(type, url, this, user);
        req.updateGivenObject(true);
        this.saveUserIfSuccess(req);
        return req;
    }

    public RequestGetOne<User> getUser(int id) {
        return this.getUser(User.class, id);
    }

    public <T extends AbstractUser> RequestGetOne<T> getUser(Class<T> type, int id) {
        String url = String.format("/v1/instances/%s/users/%d/", this.getNotEmptyInstanceName(), id);
        return new RequestGetOne<Class<T>>(type, url, this);
    }

    public <T extends AbstractUser> RequestGetOne<T> fetchCurrentUser(T user) {
        Validate.checkNotNullAndNotEmpty(this.getUserKey(), "Can't fetch user without login him first.");
        String url = String.format("/v1/instances/%s/user/", this.getNotEmptyInstanceName());
        return new RequestGetOne<T>(user, url, this);
    }

    public <T extends AbstractUser> RequestGetOne<T> fetchCurrentUser(Class<T> type) {
        Validate.checkNotNullAndNotEmpty(this.getUserKey(), "Can't fetch user without login him first.");
        String url = String.format("/v1/instances/%s/user/", this.getNotEmptyInstanceName());
        return new RequestGetOne<Class<T>>(type, url, this);
    }

    public RequestPatch<User> updateUser(User user) {
        return this.updateCustomUser(user);
    }

    public <T extends AbstractUser> RequestPatch<T> updateCustomUser(T user) {
        Validate.checkNotNullAndZero(user.getId(), "Trying to update User without giving id!");
        Class<?> type = user.getClass();
        String url = String.format("/v1/instances/%s/users/%d/", this.getNotEmptyInstanceName(), user.getId());
        return new RequestPatch(type, url, this, user);
    }

    public RequestPost<User> loginUser(String username, String password) {
        return this.loginUser(User.class, username, password);
    }

    public <T extends AbstractUser> RequestPost<T> loginUser(Class<T> type, String username, String password) {
        String url = String.format("/v1/instances/%s/user/auth/", this.getNotEmptyInstanceName());
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("username", username);
        jsonParams.addProperty("password", password);
        RequestPost<T> req = new RequestPost<T>(type, url, this, jsonParams);
        this.saveUserIfSuccess(req);
        return req;
    }

    public <T extends AbstractUser> RequestPost<T> loginUser(T user) {
        Validate.checkNotNullAndNotEmpty(user.getUserName(), "Username cannot be empty.");
        Validate.checkNotNullAndNotEmpty(user.getPassword(), "Password cannot be empty.");
        String url = String.format("/v1/instances/%s/user/auth/", this.getNotEmptyInstanceName());
        RequestPost req = new RequestPost(user.getClass(), url, this, user);
        req.updateGivenObject(true);
        this.saveUserIfSuccess(req);
        return req;
    }

    public RequestPost<User> loginSocialUser(SocialAuthBackend social, String authToken) {
        return this.loginSocialUser(User.class, social, authToken);
    }

    public <T extends AbstractUser> RequestPost<T> loginSocialUser(Class<T> type, SocialAuthBackend social, String authToken) {
        String url = String.format("/v1/instances/%s/user/auth/%s/", this.getNotEmptyInstanceName(), social.toString());
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("access_token", authToken);
        RequestPost<T> req = new RequestPost<T>(type, url, this, jsonParams);
        this.saveUserIfSuccess(req);
        return req;
    }

    public <T extends AbstractUser> RequestPost<T> loginSocialUser(T user) {
        Validate.checkNotNullAndNotEmpty(user.getAuthToken(), "Auth token cannot be empty.");
        Validate.checkNotNull(user.getSocialAuthBackend(), "You should specify social type backend.");
        String url = String.format("/v1/instances/%s/user/auth/%s/", this.getNotEmptyInstanceName(), user.getSocialAuthBackend().toString());
        RequestPost req = new RequestPost(user.getClass(), url, this, user);
        req.updateGivenObject(true);
        this.saveUserIfSuccess(req);
        return req;
    }

    private <T extends AbstractUser> void saveUserIfSuccess(HttpRequest<T> request) {
        request.setRunAfter(new Request.RunAfter<T>(){

            @Override
            public void run(Response<T> response) {
                if (!response.isSuccess() || response.getData() == null) {
                    return;
                }
                Syncano.this.setUser((AbstractUser)response.getData());
            }
        });
    }

    public RequestPost<Notification> publishOnChannel(String channelName, Notification notification) {
        String url = String.format("/v1/instances/%s/channels/%s/publish/", this.getNotEmptyInstanceName(), channelName);
        return new RequestPost<Notification>(Notification.class, url, this, notification);
    }

    RequestGetOne<Notification> pollChannel(String channelName, String room, int lastId) {
        String url = String.format("/v1/instances/%s/channels/%s/poll/", this.getNotEmptyInstanceName(), channelName);
        RequestGetOne<Class<Notification>> req = new RequestGetOne<Class<Notification>>(Notification.class, url, this);
        req.setLongConnectionTimeout();
        if (room != null) {
            req.addUrlParam("room", room);
        }
        if (lastId != 0) {
            req.addUrlParam("last_id", String.valueOf(lastId));
        }
        return req;
    }

    public RequestGetList<Notification> getChannelsHistory(String channelName) {
        return this.getChannelsHistory(channelName, null);
    }

    public RequestGetList<Notification> getChannelsHistory(String channelName, String room) {
        String url = String.format("/v1/instances/%s/channels/%s/history/", this.getNotEmptyInstanceName(), channelName);
        RequestGetList<Notification> req = new RequestGetList<Notification>(Notification.class, url, this);
        if (room != null) {
            req.addUrlParam("room", room);
        }
        return req;
    }
}

