/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.syncano.library.annotation.SyncanoClass;
import com.syncano.library.annotation.SyncanoField;
import com.syncano.library.choice.FieldType;
import com.syncano.library.data.SyncanoFile;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.utils.NanosDate;
import java.lang.reflect.Field;
import java.util.Date;

public class SyncanoClassHelper {
    public static String getSyncanoClassName(Class<? extends SyncanoObject> clazz) {
        SyncanoClass syncanoClass = clazz.getAnnotation(SyncanoClass.class);
        if (syncanoClass == null) {
            throw new RuntimeException("Class " + clazz.getSimpleName() + " is not marked with SyncanoClass annotation.");
        }
        return syncanoClass.name();
    }

    public static JsonArray getSyncanoClassSchema(Class<? extends SyncanoObject> clazz) {
        JsonArray schemaArray = new JsonArray();
        for (Field field : clazz.getDeclaredFields()) {
            String typeName;
            SyncanoField fieldAnnotation = field.getAnnotation(SyncanoField.class);
            if (fieldAnnotation == null) continue;
            JsonObject fieldDescription = new JsonObject();
            FieldType type = SyncanoClassHelper.findType(field, fieldAnnotation);
            if (type == null) continue;
            if (type.equals((Object)FieldType.REFERENCE)) {
                String target = fieldAnnotation.target();
                if (target == null || target.isEmpty()) {
                    throw new RuntimeException("Field type " + (Object)((Object)type) + " has to be declared together with " + "target");
                }
                fieldDescription.addProperty("target", target);
            }
            try {
                SerializedName nameAnn = ((Object)((Object)type)).getClass().getDeclaredField(type.name()).getAnnotation(SerializedName.class);
                typeName = nameAnn.value();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            fieldDescription.addProperty("type", typeName);
            fieldDescription.addProperty("name", SyncanoClassHelper.getFieldName(field, true));
            if (fieldAnnotation.filterIndex()) {
                fieldDescription.addProperty("filter_index", Boolean.valueOf(true));
            }
            if (fieldAnnotation.orderIndex()) {
                fieldDescription.addProperty("order_index", Boolean.valueOf(true));
            }
            schemaArray.add((JsonElement)fieldDescription);
        }
        return schemaArray;
    }

    public static String getFieldName(Field f) {
        return SyncanoClassHelper.getFieldName(f, false);
    }

    public static String getFieldName(Field f, boolean checkCapitalLetters) {
        SyncanoField syncanoField = f.getAnnotation(SyncanoField.class);
        String name = syncanoField != null ? syncanoField.name() : f.getName();
        if (checkCapitalLetters && !name.equals(name.toLowerCase())) {
            throw new RuntimeException("Can't use capital letters in field names");
        }
        return name;
    }

    public static FieldType findType(Field field, SyncanoField fieldAnnotation) {
        FieldType type = fieldAnnotation.type();
        if (type != null && !FieldType.NOT_SET.equals((Object)type)) {
            return type;
        }
        Class<?> clazz = field.getType();
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class) || clazz.equals(Byte.TYPE) || clazz.equals(Byte.class) || clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return FieldType.INTEGER;
        }
        if (clazz.equals(String.class)) {
            return FieldType.STRING;
        }
        if (clazz.equals(Date.class) || clazz.equals(NanosDate.class)) {
            return FieldType.DATETIME;
        }
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return FieldType.BOOLEAN;
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class) || clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return FieldType.FLOAT;
        }
        if (clazz.equals(SyncanoFile.class)) {
            return FieldType.FILE;
        }
        if (fieldAnnotation.readOnly()) {
            return null;
        }
        throw new RuntimeException("Field type " + clazz.getSimpleName() + " is not supported.");
    }
}

