/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.utils;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.syncano.library.annotation.SyncanoField;
import com.syncano.library.data.SyncanoFile;
import com.syncano.library.utils.DateTool;
import com.syncano.library.utils.NanosDate;
import com.syncano.library.utils.SyncanoClassHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Date;

public class GsonHelper {
    public static Gson createGson() {
        return GsonHelper.createGson(new GsonConfig());
    }

    public static <T> Gson createGson(GsonConfig config) {
        return GsonHelper.createGson(null, config);
    }

    public static <T> Gson createGson(T object) {
        return GsonHelper.createGson(object, new GsonConfig());
    }

    public static <T> Gson createGson(final T object, GsonConfig config) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(NanosDate.class, (Object)new DateSerializer());
        gsonBuilder.registerTypeAdapter(NanosDate.class, (Object)new DateDeserializer());
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateSerializer());
        gsonBuilder.registerTypeAdapter(Date.class, (Object)new DateDeserializer());
        gsonBuilder.registerTypeAdapter(SyncanoFile.class, (Object)new FileDeserializer());
        gsonBuilder.addSerializationExclusionStrategy((ExclusionStrategy)new SyncanoSerializationStrategy(config.readOnlyNotImportant));
        gsonBuilder.addDeserializationExclusionStrategy((ExclusionStrategy)new SyncanoDeserializationStrategy());
        gsonBuilder.setFieldNamingStrategy((FieldNamingStrategy)new SyncanoFieldNamingStrategy());
        if (object != null) {
            gsonBuilder.registerTypeAdapter(object.getClass(), (Object)new InstanceCreator<T>(){

                public T createInstance(Type type) {
                    return object;
                }
            });
        }
        return gsonBuilder.create();
    }

    private static class SyncanoFieldNamingStrategy
    implements FieldNamingStrategy {
        private SyncanoFieldNamingStrategy() {
        }

        public String translateName(Field f) {
            return SyncanoClassHelper.getFieldName(f);
        }
    }

    private static class SyncanoDeserializationStrategy
    implements ExclusionStrategy {
        private SyncanoDeserializationStrategy() {
        }

        public boolean shouldSkipField(FieldAttributes f) {
            SyncanoField syncanoField = (SyncanoField)f.getAnnotation(SyncanoField.class);
            return syncanoField == null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }

    private static class SyncanoSerializationStrategy
    implements ExclusionStrategy {
        private boolean readOnlyNotImportant = false;

        public SyncanoSerializationStrategy(boolean readOnlyNotImportant) {
            this.readOnlyNotImportant = readOnlyNotImportant;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            SyncanoField syncanoField = (SyncanoField)f.getAnnotation(SyncanoField.class);
            return syncanoField == null || !this.readOnlyNotImportant && syncanoField.readOnly() && !syncanoField.required() || f.getDeclaredClass().isAssignableFrom(SyncanoFile.class);
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }

    private static class FileDeserializer
    implements JsonDeserializer<SyncanoFile> {
        private FileDeserializer() {
        }

        public SyncanoFile deserialize(JsonElement json, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            String link = json.getAsJsonObject().get("value").getAsString();
            return new SyncanoFile(link);
        }
    }

    private static class DateDeserializer
    implements JsonDeserializer<Date> {
        private DateDeserializer() {
        }

        public Date deserialize(JsonElement json, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            String dateString = json.isJsonPrimitive() ? json.getAsJsonPrimitive().getAsString() : json.getAsJsonObject().get("value").getAsString();
            return DateTool.parseString(dateString);
        }
    }

    private static class DateSerializer
    implements JsonSerializer<Date> {
        private DateSerializer() {
        }

        public JsonElement serialize(Date date, Type type, JsonSerializationContext jsc) {
            return new JsonPrimitive(DateTool.parseDate(date));
        }
    }

    public static class GsonConfig {
        public boolean readOnlyNotImportant = false;
    }
}

