/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.utils;

import com.syncano.library.utils.EncryptionKey;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class Encryption {
    private static boolean strictCheckCertificate = true;
    private static final int TIMEOUT = 30000;
    private static final int SOCKET_TIMEOUT = 60000;

    public static DefaultHttpClient getHttpClient() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"utf-8");
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)30000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)60000);
        params.setBooleanParameter("http.protocol.expect-continue", false);
        if (!strictCheckCertificate) {
            return new DefaultHttpClient((HttpParams)params);
        }
        try {
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("https", (SocketFactory)Encryption.newSslSocketFactory(), 443));
            ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)params, registry);
            return new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
        }
        catch (Exception e) {
            return new DefaultHttpClient((HttpParams)params);
        }
    }

    private static SSLSocketFactory newSslSocketFactory() {
        try {
            KeyStore trusted = Encryption.getSslKey();
            SSLSocketFactory sf = new SSLSocketFactory(trusted);
            sf.setHostnameVerifier(SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
            return sf;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static KeyStore getSslKey() {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(EncryptionKey.KEY);
            KeyStore trusted = KeyStore.getInstance("BKS");
            trusted.load(in, null);
            return trusted;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setStrictCheckCertificate(boolean strictCheck) {
        strictCheckCertificate = strictCheck;
    }
}

