/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.data;

import com.syncano.library.Syncano;
import com.syncano.library.annotation.SyncanoField;
import com.syncano.library.api.Response;
import com.syncano.library.callbacks.SyncanoCallback;
import com.syncano.library.data.Profile;

public abstract class AbstractUser<P extends Profile> {
    public static final String FIELD_ID = "id";
    public static final String FIELD_USER_NAME = "username";
    public static final String FIELD_PASSWORD = "password";
    public static final String FIELD_USER_KEY = "user_key";
    public static final String FIELD_PROFILE = "profile";
    private Syncano syncano;
    @SyncanoField(name="id", readOnly=true)
    private Integer id;
    @SyncanoField(name="username", required=true)
    private String userName;
    @SyncanoField(name="password", required=true)
    private String password;
    @SyncanoField(name="user_key", readOnly=true)
    private String userKey;
    @SyncanoField(name="profile", readOnly=true)
    private P profile;

    public AbstractUser() {
    }

    public AbstractUser(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public P getProfile() {
        return this.profile;
    }

    public void setProfile(P profile) {
        this.profile = profile;
    }

    private Syncano getSyncano() {
        if (this.syncano == null) {
            return Syncano.getInstance();
        }
        return this.syncano;
    }

    public <T extends AbstractUser<P>> T on(Syncano syncano) {
        this.syncano = syncano;
        return (T)this;
    }

    public <T extends AbstractUser> Response<T> register() {
        return this.getSyncano().registerCustomUser(this).send();
    }

    public <T extends AbstractUser> void register(SyncanoCallback<T> callback) {
        this.getSyncano().registerCustomUser(this).sendAsync(callback);
    }

    public <T extends AbstractUser> Response<T> login() {
        return this.getSyncano().loginUser(this.getClass(), this.getUserName(), this.getPassword()).send();
    }

    public <T extends AbstractUser> void login(SyncanoCallback<T> callback) {
        this.getSyncano().loginUser(this.getClass(), this.getUserName(), this.getPassword()).sendAsync(callback);
    }
}

