/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.syncano.library.api.Response;
import com.syncano.library.api.ResponseGetList;
import com.syncano.library.choice.Case;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.simple.RequestBuilder;
import com.syncano.library.utils.DateTool;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Where<T extends SyncanoObject> {
    private static final String FILTER_GT = "_gt";
    private static final String FILTER_GTE = "_gte";
    private static final String FILTER_LT = "_lt";
    private static final String FILTER_LTE = "_lte";
    private static final String FILTER_EQ = "_eq";
    private static final String FILTER_INS_EQ = "_ieq";
    private static final String FILTER_NEQ = "_neq";
    private static final String FILTER_EXISTS = "_exists";
    private static final String FILTER_IN = "_in";
    private static final String FILTER_START_WITH = "_startswith";
    private static final String FILTER_INS_START_WITH = "_istartswith";
    private static final String FILTER_ENDS_WITH = "_endswith";
    private static final String FILTER_INS_ENDS_WITH = "_iendswith";
    private static final String FILTER_CONTAINS = "_contains";
    private static final String FILTER_INS_CONTAINS = "_icontains";
    private Map<String, JsonObject> query = new HashMap<String, JsonObject>();
    private RequestBuilder<T> please;

    public Where() {
    }

    public Where(RequestBuilder<T> please) {
        this();
        this.please = please;
    }

    public ResponseGetList<T> get() {
        if (this.please == null) {
            throw new RuntimeException("Can be called only from SyncanoObject.please(class).where().get()");
        }
        return this.please.get();
    }

    public Where<T> gt(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_GT, value);
        return this;
    }

    public Where<T> gt(String fieldName, String value) {
        this.addFilter(fieldName, FILTER_GT, value);
        return this;
    }

    public Where<T> gt(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_GT, value);
        return this;
    }

    public Where<T> gte(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_GTE, value);
        return this;
    }

    public Where<T> gte(String fieldName, String value) {
        this.addFilter(fieldName, FILTER_GTE, value);
        return this;
    }

    public Where<T> gte(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_GTE, value);
        return this;
    }

    public Where<T> lt(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_LT, value);
        return this;
    }

    public Where<T> lt(String fieldName, String value) {
        this.addFilter(fieldName, FILTER_LT, value);
        return this;
    }

    public Where<T> lt(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_LT, value);
        return this;
    }

    public Where<T> lte(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_LTE, value);
        return this;
    }

    public Where<T> lte(String fieldName, String value) {
        this.addFilter(fieldName, FILTER_LTE, value);
        return this;
    }

    public Where<T> lte(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_LTE, value);
        return this;
    }

    public Where<T> eq(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_EQ, value);
        return this;
    }

    public Where<T> eq(String fieldName, Boolean value) {
        this.addFilter(fieldName, FILTER_EQ, value);
        return this;
    }

    public Where<T> eq(String fieldName, String value) {
        return this.eq(fieldName, value, Case.SENSITIVE);
    }

    public Where<T> eq(String fieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_EQ : FILTER_INS_EQ;
        this.addFilter(fieldName, filterName, value);
        return this;
    }

    public Where<T> eq(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_EQ, value);
        return this;
    }

    public Where<T> neq(String fieldName, Number value) {
        this.addFilter(fieldName, FILTER_NEQ, value);
        return this;
    }

    public Where<T> neq(String fieldName, Boolean value) {
        this.addFilter(fieldName, FILTER_NEQ, value);
        return this;
    }

    public Where neq(String fieldName, String value) {
        this.addFilter(fieldName, FILTER_NEQ, value);
        return this;
    }

    public Where<T> neq(String fieldName, Date value) {
        this.addFilter(fieldName, FILTER_NEQ, value);
        return this;
    }

    public Where<T> startsWith(String fieldName, String value) {
        return this.startsWith(fieldName, value, Case.SENSITIVE);
    }

    public Where<T> startsWith(String fieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_START_WITH : FILTER_INS_START_WITH;
        this.addFilter(fieldName, filterName, value);
        return this;
    }

    public Where<T> endsWith(String fieldName, String value) {
        return this.endsWith(fieldName, value, Case.SENSITIVE);
    }

    public Where<T> endsWith(String fieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_ENDS_WITH : FILTER_INS_ENDS_WITH;
        this.addFilter(fieldName, filterName, value);
        return this;
    }

    public Where<T> contains(String fieldName, String value) {
        return this.contains(fieldName, value, Case.SENSITIVE);
    }

    public Where<T> contains(String fieldName, String value, Case caseSens) {
        String filterName = caseSens.getValue() ? FILTER_CONTAINS : FILTER_INS_CONTAINS;
        this.addFilter(fieldName, filterName, value);
        return this;
    }

    public Where<T> exists(String fieldName, Boolean exists) {
        this.addFilter(fieldName, FILTER_EXISTS, exists);
        return this;
    }

    public Where<T> in(String fieldName, Number[] values) {
        JsonArray jsonArray = new JsonArray();
        for (Number element : values) {
            jsonArray.add((JsonElement)new JsonPrimitive(element));
        }
        this.addFilter(fieldName, FILTER_IN, (JsonElement)jsonArray);
        return this;
    }

    public Where<T> in(String fieldName, Boolean[] values) {
        JsonArray jsonArray = new JsonArray();
        for (Boolean element : values) {
            jsonArray.add((JsonElement)new JsonPrimitive(element));
        }
        this.addFilter(fieldName, FILTER_IN, (JsonElement)jsonArray);
        return this;
    }

    public Where<T> in(String fieldName, String[] values) {
        JsonArray jsonArray = new JsonArray();
        for (String element : values) {
            jsonArray.add((JsonElement)new JsonPrimitive(element));
        }
        this.addFilter(fieldName, FILTER_IN, (JsonElement)jsonArray);
        return this;
    }

    public Where<T> in(String fieldName, Date[] values) {
        JsonArray jsonArray = new JsonArray();
        for (Date element : values) {
            jsonArray.add((JsonElement)new JsonPrimitive(DateTool.parseDate(element)));
        }
        this.addFilter(fieldName, FILTER_IN, (JsonElement)jsonArray);
        return this;
    }

    private void addFilter(String field, String filter, Number value) {
        this.addFilter(field, filter, (JsonElement)new JsonPrimitive(value));
    }

    private void addFilter(String field, String filter, Boolean value) {
        this.addFilter(field, filter, (JsonElement)new JsonPrimitive(value));
    }

    private void addFilter(String field, String filter, String value) {
        this.addFilter(field, filter, (JsonElement)new JsonPrimitive(value));
    }

    private void addFilter(String field, String filter, Date date) {
        this.addFilter(field, filter, (JsonElement)new JsonPrimitive(DateTool.parseDate(date)));
    }

    private void addFilter(String field, String filter, JsonElement value) {
        JsonObject jsonObject = this.query.get(field);
        if (jsonObject == null) {
            jsonObject = new JsonObject();
            this.query.put(field, jsonObject);
        }
        jsonObject.add(filter, value);
    }

    public String buildQuery() {
        return new Gson().toJson(this.query);
    }

    public Response<Integer> getCountEstimation() {
        if (this.please == null) {
            throw new RuntimeException("Can be called only from SyncanoObject.please(class).where().get()");
        }
        return this.please.getCountEstimation();
    }
}

