/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library.api;

import com.syncano.library.Syncano;
import com.syncano.library.api.FieldsFilter;
import com.syncano.library.api.HttpRequest;
import com.syncano.library.choice.FilterType;
import java.util.List;

public abstract class RequestGet<T>
extends HttpRequest<T> {
    private FieldsFilter fieldsFilter;

    public RequestGet(String url, Syncano syncano) {
        super(url, syncano);
    }

    @Override
    public String getRequestMethod() {
        return "GET";
    }

    @Override
    public void prepareUrlParams() {
        super.prepareUrlParams();
        if (this.isFieldsFilter()) {
            this.addUrlParam(this.fieldsFilter.getFilterTypeString(), this.createFilterFieldParam());
        }
    }

    private String createFilterFieldParam() {
        StringBuilder filterFields = new StringBuilder();
        for (String fieldName : this.fieldsFilter.getFieldNames()) {
            if (filterFields.length() != 0) {
                filterFields.append(',');
            }
            filterFields.append(fieldName);
        }
        return filterFields.toString();
    }

    private boolean isFieldsFilter() {
        return this.fieldsFilter != null && this.fieldsFilter.getFieldNames() != null && this.fieldsFilter.getFieldNames().size() > 0;
    }

    public RequestGet<T> setFieldsFilter(FieldsFilter fieldsFilter) {
        this.fieldsFilter = fieldsFilter;
        return this;
    }

    public RequestGet<T> selectFields(FilterType filterType, String ... fields) {
        this.fieldsFilter = new FieldsFilter(filterType, fields);
        return this;
    }

    public RequestGet<T> selectFields(FilterType filterType, List<String> fields) {
        this.fieldsFilter = new FieldsFilter(filterType, fields);
        return this;
    }
}

