/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library;

import android.content.Context;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.syncano.library.api.HttpRequest;
import com.syncano.library.api.IncrementBuilder;
import com.syncano.library.api.Request;
import com.syncano.library.api.RequestDelete;
import com.syncano.library.api.RequestGet;
import com.syncano.library.api.RequestGetList;
import com.syncano.library.api.RequestGetOne;
import com.syncano.library.api.RequestPatch;
import com.syncano.library.api.RequestPost;
import com.syncano.library.api.Response;
import com.syncano.library.choice.SocialAuthBackend;
import com.syncano.library.data.AbstractUser;
import com.syncano.library.data.Channel;
import com.syncano.library.data.CodeBox;
import com.syncano.library.data.Group;
import com.syncano.library.data.GroupMembership;
import com.syncano.library.data.Notification;
import com.syncano.library.data.SyncanoClass;
import com.syncano.library.data.SyncanoObject;
import com.syncano.library.data.Trace;
import com.syncano.library.data.User;
import com.syncano.library.data.Webhook;
import com.syncano.library.simple.RequestBuilder;
import com.syncano.library.utils.Encryption;
import com.syncano.library.utils.SyncanoClassHelper;
import com.syncano.library.utils.UserMemory;

public class Syncano {
    private static Syncano sharedInstance = null;
    private Context androidContext = null;
    protected String customServerUrl;
    protected String apiKey;
    protected AbstractUser user;
    protected String instanceName;

    public Syncano() {
        this(null, null);
    }

    public Syncano(String instanceName) {
        this(null, instanceName);
    }

    public Syncano(String apiKey, String instanceName) {
        this(null, apiKey, instanceName);
    }

    public Syncano(String apiKey, String instanceName, Context androidContext) {
        this(null, apiKey, instanceName, androidContext);
    }

    public Syncano(String customServerUrl, String apiKey, String instanceName) {
        this(customServerUrl, apiKey, instanceName, null);
    }

    public Syncano(String customServerUrl, String apiKey, String instanceName, Context androidContext) {
        this.customServerUrl = customServerUrl;
        this.apiKey = apiKey;
        this.instanceName = instanceName;
        this.androidContext = androidContext;
        this.user = UserMemory.getUserFromStorage(this);
    }

    public static Syncano init(String customServerUrl, String apiKey, String instanceName, Context androidContext) {
        sharedInstance = new Syncano(customServerUrl, apiKey, instanceName, androidContext);
        return sharedInstance;
    }

    public static Syncano init(String customServerUrl, String apiKey, String instanceName) {
        return Syncano.init(customServerUrl, apiKey, instanceName, null);
    }

    public static Syncano init(String apiKey, String instanceName, Context androidContext) {
        return Syncano.init(null, apiKey, instanceName, androidContext);
    }

    public static Syncano init(String apiKey, String instanceName) {
        return Syncano.init(null, apiKey, instanceName);
    }

    public String getUrl() {
        if (this.customServerUrl != null && !this.customServerUrl.isEmpty()) {
            return this.customServerUrl;
        }
        return "https://api.syncano.io";
    }

    public static void setStrictCheckCertificate(boolean strictCheck) {
        Encryption.setStrictCheckCertificate(strictCheck);
    }

    public static Syncano getInstance() {
        return sharedInstance;
    }

    public static void setInstance(Syncano syncano) {
        sharedInstance = syncano;
    }

    public static <T extends SyncanoObject> RequestBuilder<T> please(Class<T> clazz) {
        return new RequestBuilder<T>(clazz);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getNotEmptyInstanceName() {
        if (this.instanceName == null || this.instanceName.isEmpty()) {
            throw new RuntimeException("Syncano instance name is not set");
        }
        return this.instanceName;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getNotEmptyApiKey() {
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            throw new RuntimeException("Syncano api key is not set");
        }
        return this.apiKey;
    }

    public String getUserKey() {
        if (this.user == null) {
            return null;
        }
        return this.user.getUserKey();
    }

    public AbstractUser getUser() {
        return this.user;
    }

    public void setUser(AbstractUser user) {
        this.user = user;
        UserMemory.saveUserToStorage(this, user);
    }

    public Context getAndroidContext() {
        return this.androidContext;
    }

    public void setAndroidContext(Context ctx) {
        this.androidContext = ctx;
    }

    public <T extends SyncanoObject> RequestPost<T> createObject(T object) {
        return this.createObject(object, false);
    }

    public <T extends SyncanoObject> RequestPost<T> createObject(T object, boolean updateGivenObject) {
        Class<?> type = object.getClass();
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/", this.getNotEmptyInstanceName(), className);
        RequestPost req = new RequestPost(type, url, this, object);
        req.addCorrectHttpResponseCode(201);
        req.updateGivenObject(updateGivenObject);
        return req;
    }

    public <T extends SyncanoObject> RequestGetOne<T> getObject(Class<T> type, int id) {
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/%d/", this.getNotEmptyInstanceName(), className, id);
        RequestGetOne<Class<T>> req = new RequestGetOne<Class<T>>(type, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public <T extends SyncanoObject> RequestGetOne<T> getObject(T object) {
        if (object.getId() == null) {
            throw new RuntimeException("Can't fetch object without id");
        }
        String className = SyncanoClassHelper.getSyncanoClassName(object.getClass());
        String url = String.format("/v1/instances/%s/classes/%s/objects/%d/", this.getNotEmptyInstanceName(), className, object.getId());
        RequestGetOne<T> req = new RequestGetOne<T>(object, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public <T extends SyncanoObject> RequestGetList<T> getObjects(Class<T> type) {
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/", this.getNotEmptyInstanceName(), className);
        RequestGetList<T> req = new RequestGetList<T>(type, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public <T extends SyncanoObject> RequestGetList<T> getObjects(Class<T> type, String pageUrl) {
        RequestGetList<T> req = new RequestGetList<T>(type, pageUrl, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public <T extends SyncanoObject> RequestPatch<T> updateObject(T object) {
        return this.updateObject(object, false);
    }

    public <T extends SyncanoObject> RequestPatch<T> updateObject(T object, boolean updateGivenObject) {
        if (object.getId() == null || object.getId() == 0) {
            throw new RuntimeException("Trying to update object without id!");
        }
        Class<?> type = object.getClass();
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/%d/", this.getNotEmptyInstanceName(), className, object.getId());
        RequestPatch req = new RequestPatch(type, url, this, object);
        req.addCorrectHttpResponseCode(200);
        req.updateGivenObject(updateGivenObject);
        return req;
    }

    public <T extends SyncanoObject> RequestPatch<T> addition(T object, IncrementBuilder incrementBuilder) {
        if (object.getId() == null || object.getId() == 0) {
            throw new RuntimeException("Trying to update object without id!");
        }
        Class<?> type = object.getClass();
        return this.addition(type, object.getId(), incrementBuilder);
    }

    public <T extends SyncanoObject> RequestPatch<T> addition(Class<T> type, int id, IncrementBuilder incrementBuilder) {
        if (incrementBuilder.hasAdditionFields()) {
            throw new RuntimeException("Cannot create increment query without specify fields to increment/decrement!");
        }
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/%d/", this.getNotEmptyInstanceName(), className, id);
        JsonObject additionQuery = new JsonObject();
        incrementBuilder.build(additionQuery);
        RequestPatch<T> req = new RequestPatch<T>(type, url, this, additionQuery);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public <T extends SyncanoObject> RequestDelete<T> deleteObject(Class<T> type, int id) {
        String className = SyncanoClassHelper.getSyncanoClassName(type);
        String url = String.format("/v1/instances/%s/classes/%s/objects/%d/", this.getNotEmptyInstanceName(), className, id);
        RequestDelete<T> req = new RequestDelete<T>(type, url, this);
        req.addCorrectHttpResponseCode(204);
        req.addCorrectHttpResponseCode(404);
        return req;
    }

    public <T extends SyncanoObject> RequestDelete<T> deleteObject(T object) {
        if (object.getId() == null || object.getId() == 0) {
            throw new RuntimeException("Trying to delete object without id!");
        }
        return this.deleteObject(object.getClass(), object.getId());
    }

    public RequestPost<CodeBox> createCodeBox(CodeBox codeBox) {
        String url = String.format("/v1/instances/%s/codeboxes/", this.getNotEmptyInstanceName());
        RequestPost<CodeBox> req = new RequestPost<CodeBox>(CodeBox.class, url, this, codeBox);
        req.addCorrectHttpResponseCode(201);
        return req;
    }

    public RequestGetOne<CodeBox> getCodeBox(int id) {
        String url = String.format("/v1/instances/%s/codeboxes/%d/", this.getNotEmptyInstanceName(), id);
        RequestGetOne<Class<CodeBox>> req = new RequestGetOne<Class<CodeBox>>(CodeBox.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestGetList<CodeBox> getCodeBoxes() {
        String url = String.format("/v1/instances/%s/codeboxes/", this.getNotEmptyInstanceName());
        RequestGetList<CodeBox> req = new RequestGetList<CodeBox>(CodeBox.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPatch<CodeBox> updateCodeBox(CodeBox codeBox) {
        if (codeBox.getId() == null || codeBox.getId() == 0) {
            throw new RuntimeException("Trying to update object without id!");
        }
        String url = String.format("/v1/instances/%s/codeboxes/%d/", this.getNotEmptyInstanceName(), codeBox.getId());
        RequestPatch<CodeBox> req = new RequestPatch<CodeBox>(CodeBox.class, url, this, codeBox);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestDelete<CodeBox> deleteCodeBox(int id) {
        String url = String.format("/v1/instances/%s/codeboxes/%d/", this.getNotEmptyInstanceName(), id);
        RequestDelete<CodeBox> req = new RequestDelete<CodeBox>(CodeBox.class, url, this);
        req.addCorrectHttpResponseCode(204);
        req.addCorrectHttpResponseCode(404);
        return req;
    }

    public RequestPost<Trace> runCodeBox(int id) {
        return this.runCodeBox(id, null);
    }

    public RequestPost<Trace> runCodeBox(int id, JsonObject params) {
        String url = String.format("/v1/instances/%s/codeboxes/%d/run/", this.getNotEmptyInstanceName(), id);
        JsonObject payload = new JsonObject();
        payload.add("payload", (JsonElement)params);
        RequestPost<Trace> req = new RequestPost<Trace>(Trace.class, url, this, payload);
        this.addCodeboxIdAfterCall(req, id);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPost<Trace> runCodeBox(CodeBox codeBox) {
        return this.runCodeBox(codeBox, null);
    }

    public RequestPost<Trace> runCodeBox(final CodeBox codeBox, JsonObject params) {
        if (codeBox.getId() == null) {
            throw new RuntimeException("Can't run codebox without giving it's id");
        }
        RequestPost<Trace> req = this.runCodeBox(codeBox.getId(), params);
        req.setRunAfter(new Request.RunAfter<Trace>(){

            @Override
            public void run(Response<Trace> response) {
                Trace trace = response.getData();
                if (trace == null) {
                    return;
                }
                trace.setCodeBoxId(codeBox.getId());
                codeBox.setTrace(trace);
            }
        });
        return req;
    }

    public RequestGet<Trace> getTrace(int codeboxId, int traceId) {
        String url = String.format("/v1/instances/%s/codeboxes/%d/traces/%d/", this.getNotEmptyInstanceName(), codeboxId, traceId);
        RequestGetOne<Class<Trace>> req = new RequestGetOne<Class<Trace>>(Trace.class, url, this);
        this.addCodeboxIdAfterCall(req, codeboxId);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestGet<Trace> getTrace(Trace trace) {
        if (trace.getCodeBoxId() == null) {
            throw new RuntimeException("Fetching trace result without codebox id. If run from webhook, result is already known.");
        }
        String url = String.format("/v1/instances/%s/codeboxes/%d/traces/%d/", this.getNotEmptyInstanceName(), trace.getCodeBoxId(), trace.getId());
        RequestGetOne<Trace> req = new RequestGetOne<Trace>(trace, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    private void addCodeboxIdAfterCall(HttpRequest<Trace> req, final int codeboxId) {
        req.setRunAfter(new Request.RunAfter<Trace>(){

            @Override
            public void run(Response<Trace> response) {
                Trace trace = response.getData();
                if (trace != null) {
                    trace.setCodeBoxId(codeboxId);
                }
            }
        });
    }

    public RequestPost<Webhook> createWebhook(final Webhook webhook) {
        String url = String.format("/v1/instances/%s/webhooks/", this.getNotEmptyInstanceName());
        RequestPost<Webhook> req = new RequestPost<Webhook>(Webhook.class, url, this, webhook);
        req.updateGivenObject(true);
        req.addCorrectHttpResponseCode(201);
        req.setRunAfter(new Request.RunAfter<Webhook>(){

            @Override
            public void run(Response<Webhook> response) {
                webhook.on(Syncano.this);
            }
        });
        return req;
    }

    public RequestGetOne<Webhook> getWebhook(String name) {
        String url = String.format("/v1/instances/%s/webhooks/%s/", this.getNotEmptyInstanceName(), name);
        RequestGetOne<Class<Webhook>> req = new RequestGetOne<Class<Webhook>>(Webhook.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestGetList<Webhook> getWebhooks() {
        String url = String.format("/v1/instances/%s/webhooks/", this.getNotEmptyInstanceName());
        RequestGetList<Webhook> req = new RequestGetList<Webhook>(Webhook.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPatch<Webhook> updateWebhook(Webhook webhook) {
        if (webhook.getName() == null || webhook.getName().isEmpty()) {
            throw new RuntimeException("Trying to update Webhook without name!");
        }
        String url = String.format("/v1/instances/%s/webhooks/%s/", this.getNotEmptyInstanceName(), webhook.getName());
        RequestPatch<Webhook> req = new RequestPatch<Webhook>(Webhook.class, url, this, webhook);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestDelete<Webhook> deleteWebhook(String name) {
        String url = String.format("/v1/instances/%s/webhooks/%s/", this.getNotEmptyInstanceName(), name);
        RequestDelete<Webhook> req = new RequestDelete<Webhook>(Webhook.class, url, this);
        req.addCorrectHttpResponseCode(204);
        req.addCorrectHttpResponseCode(404);
        return req;
    }

    public RequestPost<Trace> runWebhook(String name) {
        return this.runWebhook(name, null);
    }

    public RequestPost<String> runWebhookCustomResponse(String name) {
        return this.runWebhookCustomResponse(name, String.class);
    }

    public <T> RequestPost<T> runWebhookCustomResponse(String name, Class<T> type) {
        return this.runWebhookCustomResponse(name, type, null);
    }

    public RequestPost<Trace> runWebhook(String name, JsonObject payload) {
        return this.runWebhookCustomResponse(name, Trace.class, payload);
    }

    public RequestPost<String> runWebhookCustomResponse(String name, JsonObject payload) {
        return this.runWebhookCustomResponse(name, String.class, payload);
    }

    public <T> RequestPost<T> runWebhookCustomResponse(String name, Class<T> type, JsonObject payload) {
        String url = String.format("/v1/instances/%s/webhooks/%s/run/", this.getNotEmptyInstanceName(), name);
        RequestPost<T> req = new RequestPost<T>(type, url, this, payload);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPost<Trace> runWebhook(Webhook webhook) {
        return this.runWebhook(webhook, null);
    }

    public RequestPost<String> runWebhookCustomResponse(Webhook webhook) {
        return this.runWebhookCustomResponse(webhook, String.class);
    }

    public <T> RequestPost<T> runWebhookCustomResponse(Webhook webhook, Class<T> type) {
        return this.runWebhookCustomResponse(webhook, type, null);
    }

    public RequestPost<Trace> runWebhook(Webhook webhook, JsonObject payload) {
        return this.runWebhookCustomResponse(webhook, Trace.class, payload);
    }

    public RequestPost<String> runWebhookCustomResponse(Webhook webhook, JsonObject payload) {
        return this.runWebhookCustomResponse(webhook, String.class, payload);
    }

    public <T> RequestPost<T> runWebhookCustomResponse(final Webhook webhook, final Class<T> type, JsonObject payload) {
        if (webhook.getName() == null) {
            throw new RuntimeException("Can't run webhook without a name.");
        }
        RequestPost<T> req = this.runWebhookCustomResponse(webhook.getName(), type, payload);
        req.setRunAfter(new Request.RunAfter<T>(){

            @Override
            public void run(Response<T> response) {
                if (type.equals(Trace.class)) {
                    webhook.setTrace((Trace)response.getData());
                } else {
                    webhook.setCustomResponse(response.getData());
                }
            }
        });
        return req;
    }

    public RequestPost<Trace> runWebhookUrl(String url) {
        return this.runWebhookUrl(url, null);
    }

    public RequestPost<String> runWebhookUrlCustomResponse(String url) {
        return this.runWebhookUrlCustomResponse(url, String.class);
    }

    public <T> RequestPost<T> runWebhookUrlCustomResponse(String url, Class<T> type) {
        return this.runWebhookUrlCustomResponse(url, type, null);
    }

    public RequestPost<Trace> runWebhookUrl(String url, JsonObject payload) {
        return this.runWebhookUrlCustomResponse(url, Trace.class, payload);
    }

    public RequestPost<String> runWebhookUrlCustomResponse(String url, JsonObject payload) {
        return this.runWebhookUrlCustomResponse(url, String.class, payload);
    }

    public <T> RequestPost<T> runWebhookUrlCustomResponse(String url, Class<T> type, JsonObject payload) {
        RequestPost<T> req = new RequestPost<T>(type, null, this, payload);
        req.setCompleteCustomUrl(url);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPost<SyncanoClass> createSyncanoClass(SyncanoClass clazz) {
        String url = String.format("/v1/instances/%s/classes/", this.getNotEmptyInstanceName());
        RequestPost<SyncanoClass> req = new RequestPost<SyncanoClass>(SyncanoClass.class, url, this, clazz);
        req.addCorrectHttpResponseCode(201);
        return req;
    }

    public RequestPost<SyncanoClass> createSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.createSyncanoClass(new SyncanoClass(clazz));
    }

    public RequestGetOne<SyncanoClass> getSyncanoClass(String name) {
        String url = String.format("/v1/instances/%s/classes/%s/", this.getNotEmptyInstanceName(), name);
        RequestGetOne<Class<SyncanoClass>> req = new RequestGetOne<Class<SyncanoClass>>(SyncanoClass.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestGetOne<SyncanoClass> getSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.getSyncanoClass(SyncanoClassHelper.getSyncanoClassName(clazz));
    }

    public RequestGetList<SyncanoClass> getSyncanoClasses() {
        String url = String.format("/v1/instances/%s/classes/", this.getNotEmptyInstanceName());
        RequestGetList<SyncanoClass> req = new RequestGetList<SyncanoClass>(SyncanoClass.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPatch<SyncanoClass> updateSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.updateSyncanoClass(new SyncanoClass(clazz));
    }

    public RequestPatch<SyncanoClass> updateSyncanoClass(SyncanoClass clazz) {
        if (clazz.getName() == null || clazz.getName().isEmpty()) {
            throw new RuntimeException("Trying to update SyncanoClass without giving name!");
        }
        String url = String.format("/v1/instances/%s/classes/%s/", this.getNotEmptyInstanceName(), clazz.getName());
        RequestPatch<SyncanoClass> req = new RequestPatch<SyncanoClass>(SyncanoClass.class, url, this, clazz);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestDelete<SyncanoClass> deleteSyncanoClass(String name) {
        String url = String.format("/v1/instances/%s/classes/%s/", this.getNotEmptyInstanceName(), name);
        RequestDelete<SyncanoClass> req = new RequestDelete<SyncanoClass>(SyncanoClass.class, url, this);
        req.addCorrectHttpResponseCode(204);
        req.addCorrectHttpResponseCode(404);
        return req;
    }

    public RequestDelete<SyncanoClass> deleteSyncanoClass(Class<? extends SyncanoObject> clazz) {
        return this.deleteSyncanoClass(SyncanoClassHelper.getSyncanoClassName(clazz));
    }

    public RequestPost<User> registerUser(User user) {
        return this.registerCustomUser(user);
    }

    public <T extends AbstractUser> RequestPost<T> registerCustomUser(T user) {
        Class<?> type = user.getClass();
        String url = String.format("/v1/instances/%s/users/", this.getNotEmptyInstanceName());
        RequestPost req = new RequestPost(type, url, this, user);
        req.addCorrectHttpResponseCode(201);
        return req;
    }

    public RequestGetOne<User> getUser(int id) {
        return this.getUser(User.class, id);
    }

    public <T extends AbstractUser> RequestGetOne<T> getUser(Class<T> type, int id) {
        String url = String.format("/v1/instances/%s/users/%d/", this.getNotEmptyInstanceName(), id);
        RequestGetOne<Class<T>> req = new RequestGetOne<Class<T>>(type, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestGetList<User> getUsers() {
        return this.getUsers(User.class);
    }

    public <T extends AbstractUser> RequestGetList<T> getUsers(Class<T> type) {
        String url = String.format("/v1/instances/%s/users/", this.getNotEmptyInstanceName());
        RequestGetList<T> req = new RequestGetList<T>(type, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPatch<User> updateUser(User user) {
        return this.updateCustomUser(user);
    }

    public <T extends AbstractUser> RequestPatch<T> updateCustomUser(T user) {
        if (user.getId() == null || user.getId() == 0) {
            throw new RuntimeException("Trying to update User without giving id!");
        }
        Class<?> type = user.getClass();
        String url = String.format("/v1/instances/%s/users/%d/", this.getNotEmptyInstanceName(), user.getId());
        RequestPatch req = new RequestPatch(type, url, this, user);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestDelete<User> deleteUser(int id) {
        return this.deleteUser(User.class, id);
    }

    public <T extends AbstractUser> RequestDelete<T> deleteUser(Class<T> type, int id) {
        String url = String.format("/v1/instances/%s/users/%d/", this.getNotEmptyInstanceName(), id);
        RequestDelete<T> req = new RequestDelete<T>(type, url, this);
        req.addCorrectHttpResponseCode(204);
        req.addCorrectHttpResponseCode(404);
        return req;
    }

    public RequestPost<User> loginUser(String username, String password) {
        return this.loginUser(User.class, username, password);
    }

    public <T extends AbstractUser> RequestPost<T> loginUser(Class<T> type, String username, String password) {
        String url = String.format("/v1/instances/%s/user/auth/", this.getNotEmptyInstanceName());
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("username", username);
        jsonParams.addProperty("password", password);
        RequestPost<T> req = new RequestPost<T>(type, url, this, jsonParams);
        this.saveUserIfSuccess(req);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPost<User> loginSocialUser(SocialAuthBackend social, String authToken) {
        return this.loginSocialUser(User.class, social, authToken);
    }

    public <T extends AbstractUser> RequestPost<T> loginSocialUser(Class<T> type, SocialAuthBackend social, String authToken) {
        String url = String.format("/v1/instances/%s/user/auth/%s/", this.getNotEmptyInstanceName(), social.toString());
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("access_token", authToken);
        RequestPost<T> req = new RequestPost<T>(type, url, this, jsonParams);
        this.saveUserIfSuccess(req);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    private <T extends AbstractUser> void saveUserIfSuccess(HttpRequest<T> request) {
        request.setRunAfter(new Request.RunAfter<T>(){

            @Override
            public void run(Response<T> response) {
                if (!response.isSuccess() || response.getData() == null) {
                    return;
                }
                Syncano.this.setUser((AbstractUser)response.getData());
            }
        });
    }

    public RequestPost<Group> createGroup(Group group) {
        String url = String.format("/v1/instances/%s/groups/", this.getNotEmptyInstanceName());
        RequestPost<Group> req = new RequestPost<Group>(Group.class, url, this, group);
        req.addCorrectHttpResponseCode(201);
        return req;
    }

    public RequestGetOne<Group> getGroup(int id) {
        String url = String.format("/v1/instances/%s/groups/%d/", this.getNotEmptyInstanceName(), id);
        RequestGetOne<Class<Group>> req = new RequestGetOne<Class<Group>>(Group.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestGetList<Group> getGroups() {
        String url = String.format("/v1/instances/%s/groups/", this.getNotEmptyInstanceName());
        RequestGetList<Group> req = new RequestGetList<Group>(Group.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPatch<Group> updateGroup(Group group) {
        if (group.getId() == null || group.getId() == 0) {
            throw new RuntimeException("Trying to update Group without id!");
        }
        String url = String.format("/v1/instances/%s/groups/%d/", this.getNotEmptyInstanceName(), group.getId());
        RequestPatch<Group> req = new RequestPatch<Group>(Group.class, url, this, group);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestDelete<Group> deleteGroup(int id) {
        String url = String.format("/v1/instances/%s/groups/%d/", this.getNotEmptyInstanceName(), id);
        RequestDelete<Group> req = new RequestDelete<Group>(Group.class, url, this);
        req.addCorrectHttpResponseCode(404);
        req.addCorrectHttpResponseCode(204);
        return req;
    }

    public RequestGetOne<GroupMembership> getGroupMembership(int groupId, int userId) {
        String url = String.format("/v1/instances/%s/groups/%d/users/%d/", this.getNotEmptyInstanceName(), groupId, userId);
        RequestGetOne<Class<GroupMembership>> req = new RequestGetOne<Class<GroupMembership>>(GroupMembership.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestGetList<GroupMembership> getGroupMemberships(int groupId) {
        String url = String.format("/v1/instances/%s/groups/%d/users/", this.getNotEmptyInstanceName(), groupId);
        RequestGetList<GroupMembership> req = new RequestGetList<GroupMembership>(GroupMembership.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPost<GroupMembership> addUserToGroup(int groupId, int userId) {
        String url = String.format("/v1/instances/%s/groups/%d/users/", this.getNotEmptyInstanceName(), groupId);
        JsonObject jsonParams = new JsonObject();
        jsonParams.addProperty("user", (Number)userId);
        RequestPost<GroupMembership> req = new RequestPost<GroupMembership>(GroupMembership.class, url, this, jsonParams);
        req.addCorrectHttpResponseCode(201);
        return req;
    }

    public RequestDelete<GroupMembership> deleteUserFromGroup(int groupId, int userId) {
        String url = String.format("/v1/instances/%s/groups/%d/users/%d/", this.getNotEmptyInstanceName(), groupId, userId);
        RequestDelete<GroupMembership> req = new RequestDelete<GroupMembership>(GroupMembership.class, url, this);
        req.addCorrectHttpResponseCode(404);
        req.addCorrectHttpResponseCode(204);
        return req;
    }

    public RequestPost<Channel> createChannel(Channel channel) {
        String url = String.format("/v1/instances/%s/channels/", this.getNotEmptyInstanceName());
        RequestPost<Channel> req = new RequestPost<Channel>(Channel.class, url, this, channel);
        req.addCorrectHttpResponseCode(201);
        return req;
    }

    public RequestGetOne<Channel> getChannel(String channelName) {
        String url = String.format("/v1/instances/%s/channels/%s/", this.getNotEmptyInstanceName(), channelName);
        RequestGetOne<Class<Channel>> req = new RequestGetOne<Class<Channel>>(Channel.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestGetList<Channel> getChannels() {
        String url = String.format("/v1/instances/%s/channels/", this.getNotEmptyInstanceName());
        RequestGetList<Channel> req = new RequestGetList<Channel>(Channel.class, url, this);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPatch<Channel> updateChannel(Channel channel) {
        if (channel.getName() == null || channel.getName().isEmpty()) {
            throw new RuntimeException("Trying to update Channel without name!");
        }
        String url = String.format("/v1/instances/%s/channels/%s/", this.getNotEmptyInstanceName(), channel.getName());
        RequestPatch<Channel> req = new RequestPatch<Channel>(Channel.class, url, this, channel);
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestDelete<Channel> deleteChannel(String channelName) {
        String url = String.format("/v1/instances/%s/channels/%s/", this.getNotEmptyInstanceName(), channelName);
        RequestDelete<Channel> req = new RequestDelete<Channel>(Channel.class, url, this);
        req.addCorrectHttpResponseCode(404);
        req.addCorrectHttpResponseCode(204);
        return req;
    }

    public RequestGetList<Notification> getChannelsHistory(String channelName) {
        return this.getChannelsHistory(channelName, null);
    }

    public RequestGetList<Notification> getChannelsHistory(String channelName, String room) {
        String url = String.format("/v1/instances/%s/channels/%s/history/", this.getNotEmptyInstanceName(), channelName);
        RequestGetList<Notification> req = new RequestGetList<Notification>(Notification.class, url, this);
        if (room != null) {
            req.addUrlParam("room", room);
        }
        req.addCorrectHttpResponseCode(200);
        return req;
    }

    public RequestPost<Notification> publishOnChannel(String channelName, Notification notification) {
        String url = String.format("/v1/instances/%s/channels/%s/publish/", this.getNotEmptyInstanceName(), channelName);
        RequestPost<Notification> req = new RequestPost<Notification>(Notification.class, url, this, notification);
        req.addCorrectHttpResponseCode(201);
        return req;
    }

    RequestGetOne<Notification> pollChannel(String channelName, String room, int lastId) {
        String url = String.format("/v1/instances/%s/channels/%s/poll/", this.getNotEmptyInstanceName(), channelName);
        RequestGetOne<Class<Notification>> req = new RequestGetOne<Class<Notification>>(Notification.class, url, this);
        req.setLongConnectionTimeout();
        if (room != null) {
            req.addUrlParam("room", room);
        }
        if (lastId != 0) {
            req.addUrlParam("last_id", String.valueOf(lastId));
        }
        req.addCorrectHttpResponseCode(200);
        req.addCorrectHttpResponseCode(204);
        return req;
    }
}

