/*
 * Decompiled with CFR 0.152.
 */
package com.syncano.library;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Executor;

public class PlatformType {
    private static final PlatformType PLATFORM_TYPE = PlatformType.getPlatformType();

    public static PlatformType get() {
        return PLATFORM_TYPE;
    }

    private static PlatformType getPlatformType() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new AndroidPlatform();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new PlatformType();
    }

    public void runOnCallbackThread(Runnable runnable) {
        if (this.getDefaultCallbackExecutor() != null) {
            this.getDefaultCallbackExecutor().execute(runnable);
        } else {
            runnable.run();
        }
    }

    public Executor getDefaultCallbackExecutor() {
        return null;
    }

    public static class AndroidPlatform
    extends PlatformType {
        private MainThreadExecutor mainThreadExecutor = new MainThreadExecutor();

        @Override
        public Executor getDefaultCallbackExecutor() {
            return this.mainThreadExecutor;
        }

        static class MainThreadExecutor
        implements Executor {
            private final Handler handler = new Handler(Looper.getMainLooper());

            MainThreadExecutor() {
            }

            @Override
            public void execute(Runnable r) {
                this.handler.post(r);
            }
        }
    }
}

