/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import io.swagger.parser.extensions.SwaggerParserExtension;
import io.swagger.parser.models.AuthorizationValue;
import io.swagger.parser.models.ParseOptions;
import io.swagger.parser.models.SwaggerParseResult;
import io.swagger.parser.v3.OpenAPIV3Parser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class OpenAPIParser {
    public SwaggerParseResult readLocation(String url, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult output = null;
        for (SwaggerParserExtension extension : this.getExtensions()) {
            output = extension.readLocation(url, this.transform(auth), options);
            if (output == null || output.getOpenAPI() == null) continue;
            return output;
        }
        return output;
    }

    public SwaggerParseResult readContents(String swaggerAsString, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult output = null;
        for (SwaggerParserExtension extension : this.getExtensions()) {
            output = extension.readContents(swaggerAsString, this.transform(auth), options);
            if (output == null || output.getOpenAPI() == null) continue;
            return output;
        }
        return output;
    }

    protected List<SwaggerParserExtension> getExtensions() {
        ArrayList<SwaggerParserExtension> extensions = new ArrayList<SwaggerParserExtension>();
        ServiceLoader<SwaggerParserExtension> loader = ServiceLoader.load(SwaggerParserExtension.class);
        Iterator<SwaggerParserExtension> itr = loader.iterator();
        while (itr.hasNext()) {
            extensions.add(itr.next());
        }
        extensions.add(0, (SwaggerParserExtension)new OpenAPIV3Parser());
        return extensions;
    }

    protected List<AuthorizationValue> transform(List<AuthorizationValue> input) {
        if (input == null) {
            return null;
        }
        ArrayList<AuthorizationValue> output = new ArrayList<AuthorizationValue>();
        for (AuthorizationValue value : input) {
            AuthorizationValue v = new AuthorizationValue();
            v.setKeyName(value.getKeyName());
            v.setValue(value.getValue());
            v.setType(value.getType());
            output.add(v);
        }
        return output;
    }
}

