/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3.processors;

import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.headers.Header;
import io.swagger.oas.models.links.Link;
import io.swagger.parser.v3.ResolverCache;
import io.swagger.parser.v3.models.RefFormat;
import io.swagger.parser.v3.processors.ExternalRefProcessor;
import io.swagger.parser.v3.processors.HeaderProcessor;
import io.swagger.parser.v3.util.RefUtils;
import java.util.Map;

public class LinkProcessor {
    private final ResolverCache cache;
    private final OpenAPI openAPI;
    private final HeaderProcessor headerProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public LinkProcessor(ResolverCache cache, OpenAPI openAPI) {
        this.cache = cache;
        this.openAPI = openAPI;
        this.headerProcessor = new HeaderProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processLink(Link link) {
        if (link.get$ref() != null) {
            String newRef;
            RefFormat refFormat = RefUtils.computeRefFormat(link.get$ref());
            String $ref = link.get$ref();
            if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalLink($ref, refFormat)) != null) {
                link.set$ref(newRef);
            }
        } else if (link.getHeaders() != null) {
            Map headers = link.getHeaders();
            for (String headerName : headers.keySet()) {
                Header header = (Header)headers.get(headerName);
                this.headerProcessor.processHeader(header);
            }
        }
    }
}

