/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.oas.models.OpenAPI;
import io.swagger.oas.models.media.Schema;
import io.swagger.parser.models.AuthorizationValue;
import io.swagger.parser.v3.models.RefFormat;
import io.swagger.parser.v3.models.RefType;
import io.swagger.parser.v3.util.DeserializationUtils;
import io.swagger.parser.v3.util.OpenAPIDeserializer;
import io.swagger.parser.v3.util.PathUtils;
import io.swagger.parser.v3.util.RefUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResolverCache {
    private static final Pattern SCHEMAS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "schemas/(?<name>.+)");
    private static final Pattern RESPONSES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "responses/(?<name>.+)");
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "parameters/(?<name>.+)");
    private static final Pattern REQUEST_BODIES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "requestBodies/(?<name>.+)");
    private static final Pattern EXAMPLES_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "examples/(?<name>.+)");
    private static final Pattern LINKS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "links/(?<name>.+)");
    private static final Pattern CALLBACKS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "callbacks/(?<name>.+)");
    private static final Pattern HEADERS_PATTERN = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "headers/(?<name>.+)");
    private static final Pattern SECURITY_SCHEMES = Pattern.compile("^" + RefType.COMPONENTS.getInternalPrefix() + "securitySchemes/(?<name>.+)");
    private static final Pattern PATHS_PATTERN = Pattern.compile("^" + RefType.PATH.getInternalPrefix() + "(?<name>.+)");
    private final OpenAPI openApi;
    private final List<AuthorizationValue> auths;
    private final Path parentDirectory;
    private final String rootPath;
    private Map<String, Object> resolutionCache = new HashMap<String, Object>();
    private Map<String, String> externalFileCache = new HashMap<String, String>();
    private Set<String> referencedModelKeys = new HashSet<String>();
    private Map<String, String> renameCache = new HashMap<String, String>();

    public ResolverCache(OpenAPI openApi, List<AuthorizationValue> auths, String parentFileLocation) {
        this.openApi = openApi;
        this.auths = auths;
        this.rootPath = parentFileLocation;
        if (parentFileLocation != null) {
            this.parentDirectory = parentFileLocation.startsWith("http") ? null : PathUtils.getParentDirectoryOfFile(parentFileLocation);
        } else {
            File file = new File(".");
            this.parentDirectory = file.toPath();
        }
    }

    public <T> T loadRef(String ref, RefFormat refFormat, Class<T> expectedType) {
        Object result;
        String[] jsonPathElements;
        if (refFormat == RefFormat.INTERNAL) {
            Object loadedRef = this.loadInternalRef(ref);
            try {
                return expectedType.cast(loadedRef);
            }
            catch (Exception e) {
                return null;
            }
        }
        String[] refParts = ref.split("#/");
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file = refParts[0];
        String definitionPath = refParts.length == 2 ? refParts[1] : null;
        Object previouslyResolvedEntity = this.resolutionCache.get(ref);
        if (previouslyResolvedEntity != null) {
            return expectedType.cast(previouslyResolvedEntity);
        }
        String contents = this.externalFileCache.get(file);
        if (contents == null) {
            if (this.parentDirectory != null) {
                contents = RefUtils.readExternalRef(file, refFormat, this.auths, this.parentDirectory);
            } else if (this.rootPath != null) {
                contents = RefUtils.readExternalUrlRef(file, refFormat, this.auths, this.rootPath);
            }
            this.externalFileCache.put(file, contents);
        }
        if (definitionPath == null) {
            T result2 = DeserializationUtils.deserialize(contents, file, expectedType);
            this.resolutionCache.put(ref, result2);
            return result2;
        }
        JsonNode tree = DeserializationUtils.deserializeIntoTree(contents, file);
        for (String jsonPathElement : jsonPathElements = definitionPath.split("/")) {
            if ((tree = tree.get(this.unescapePointer(jsonPathElement))) != null) continue;
            throw new RuntimeException("Could not find " + definitionPath + " in contents of " + file);
        }
        if (expectedType.equals(Schema.class)) {
            OpenAPIDeserializer deserializer = new OpenAPIDeserializer();
            result = deserializer.getSchema((ObjectNode)tree, definitionPath.replace("/", "."), null);
        } else {
            result = DeserializationUtils.deserialize(tree, file, expectedType);
        }
        this.resolutionCache.put(ref, result);
        return result;
    }

    private Object loadInternalRef(String ref) {
        Object result = null;
        if (ref.startsWith("#/components/schemas")) {
            result = this.getFromMap(ref, this.openApi.getComponents().getSchemas(), SCHEMAS_PATTERN);
        } else if (ref.startsWith("#/components/requestBodies")) {
            result = this.getFromMap(ref, this.openApi.getComponents().getRequestBodies(), REQUEST_BODIES_PATTERN);
        } else if (ref.startsWith("#/components/examples")) {
            result = this.getFromMap(ref, this.openApi.getComponents().getExamples(), EXAMPLES_PATTERN);
        } else if (ref.startsWith("#/components/responses")) {
            result = this.getFromMap(ref, this.openApi.getComponents().getResponses(), RESPONSES_PATTERN);
        } else if (ref.startsWith("#/components/parameters")) {
            result = this.getFromMap(ref, this.openApi.getComponents().getParameters(), PARAMETERS_PATTERN);
        } else if (ref.startsWith("#/components/links")) {
            result = this.getFromMap(ref, this.openApi.getComponents().getLinks(), LINKS_PATTERN);
        } else if (ref.startsWith("#/components/headers")) {
            result = this.getFromMap(ref, this.openApi.getComponents().getHeaders(), HEADERS_PATTERN);
        } else if (ref.startsWith("#/components/callbacks")) {
            result = this.getFromMap(ref, this.openApi.getComponents().getCallbacks(), CALLBACKS_PATTERN);
        } else if (ref.startsWith("#/components/securitySchemes")) {
            result = this.getFromMap(ref, this.openApi.getComponents().getSecuritySchemes(), SECURITY_SCHEMES);
        } else if (ref.startsWith("#/paths")) {
            result = this.getFromMap(ref, (Map)this.openApi.getPaths(), PATHS_PATTERN);
        }
        return result;
    }

    private String unescapePointer(String jsonPathElement) {
        jsonPathElement = jsonPathElement.replaceAll("~1", "/");
        return jsonPathElement.replaceAll("~0", "~");
    }

    private Object getFromMap(String ref, Map map, Pattern pattern) {
        Matcher parameterMatcher = pattern.matcher(ref);
        if (parameterMatcher.matches()) {
            String paramName = this.unescapePointer(parameterMatcher.group("name"));
            if (map != null) {
                return map.get(paramName);
            }
        }
        return null;
    }

    public boolean hasReferencedKey(String modelKey) {
        if (this.referencedModelKeys == null) {
            return false;
        }
        return this.referencedModelKeys.contains(modelKey);
    }

    public void addReferencedKey(String modelKey) {
        this.referencedModelKeys.add(modelKey);
    }

    public String getRenamedRef(String originalRef) {
        return this.renameCache.get(originalRef);
    }

    public void putRenamedRef(String originalRef, String newRef) {
        this.renameCache.put(originalRef, newRef);
    }

    public Map<String, Object> getResolutionCache() {
        return Collections.unmodifiableMap(this.resolutionCache);
    }

    public Map<String, String> getExternalFileCache() {
        return Collections.unmodifiableMap(this.externalFileCache);
    }

    public Map<String, String> getRenameCache() {
        return Collections.unmodifiableMap(this.renameCache);
    }
}

