/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.v3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.oas.models.OpenAPI;
import io.swagger.parser.extensions.SwaggerParserExtension;
import io.swagger.parser.models.AuthorizationValue;
import io.swagger.parser.models.ParseOptions;
import io.swagger.parser.models.SwaggerParseResult;
import io.swagger.parser.v3.ObjectMapperFactory;
import io.swagger.parser.v3.OpenAPIResolver;
import io.swagger.parser.v3.util.ClasspathHelper;
import io.swagger.parser.v3.util.OpenAPIDeserializer;
import io.swagger.parser.v3.util.RemoteUrl;
import io.swagger.parser.v3.util.ResolverFully;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;

public class OpenAPIV3Parser
implements SwaggerParserExtension {
    private static ObjectMapper JSON_MAPPER = ObjectMapperFactory.createJson();
    private static ObjectMapper YAML_MAPPER = ObjectMapperFactory.createYaml();

    public SwaggerParseResult readLocation(String url, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult result = new SwaggerParseResult();
        try {
            result = this.readWithInfo(url, auth);
            if (result.getOpenAPI() != null) {
                String version = result.getOpenAPI().getOpenapi();
                if (auth == null) {
                    auth = new ArrayList<AuthorizationValue>();
                }
                if (version != null && version.startsWith("3.0") && options != null) {
                    OpenAPIResolver resolver = new OpenAPIResolver(result.getOpenAPI(), auth, null);
                    if (options.isResolve()) {
                        result.setOpenAPI(resolver.resolve());
                    }
                    if (options.isResolveFully()) {
                        result.setOpenAPI(resolver.resolve());
                        new ResolverFully().resolveFully(result.getOpenAPI());
                    }
                }
            }
        }
        catch (Exception e) {
            result.setMessages(Arrays.asList(e.getMessage()));
        }
        return result;
    }

    public OpenAPI read(String location) {
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        return this.read(location, null, options);
    }

    public OpenAPI read(String location, List<AuthorizationValue> auths, ParseOptions resolve) {
        if (location == null) {
            return null;
        }
        location = location.replaceAll("\\\\", "/");
        List<SwaggerParserExtension> parserExtensions = this.getExtensions();
        for (SwaggerParserExtension extension : parserExtensions) {
            OpenAPI output = extension.readLocation(location, auths, resolve).getOpenAPI();
            if (output == null) continue;
            return output;
        }
        return null;
    }

    public SwaggerParseResult readWithInfo(JsonNode node) {
        OpenAPIDeserializer ser = new OpenAPIDeserializer();
        return ser.deserialize(node);
    }

    private ObjectMapper getRightMapper(String data) {
        ObjectMapper mapper = data.trim().startsWith("{") ? JSON_MAPPER : YAML_MAPPER;
        return mapper;
    }

    public SwaggerParseResult readWithInfo(String location, List<AuthorizationValue> auths) {
        try {
            String data;
            location = location.replaceAll("\\\\", "/");
            if (location.toLowerCase().startsWith("http")) {
                data = RemoteUrl.urlToString(location, auths);
            } else {
                String fileScheme = "file:";
                Path path = location.toLowerCase().startsWith("file:") ? Paths.get(URI.create(location)) : Paths.get(location, new String[0]);
                data = Files.exists(path, new LinkOption[0]) ? FileUtils.readFileToString((File)path.toFile(), (String)"UTF-8") : ClasspathHelper.loadFileFromClasspath(location);
            }
            ObjectMapper mapper = this.getRightMapper(data);
            JsonNode rootNode = mapper.readTree(data);
            return this.readWithInfo(rootNode);
        }
        catch (SSLHandshakeException e) {
            SwaggerParseResult output = new SwaggerParseResult();
            output.setMessages(Arrays.asList("unable to read location `" + location + "` due to a SSL configuration error.  It is possible that the server SSL certificate is invalid, self-signed, or has an untrusted Certificate Authority."));
            return output;
        }
        catch (Exception e) {
            SwaggerParseResult output = new SwaggerParseResult();
            output.setMessages(Arrays.asList("unable to read location `" + location + "`"));
            return output;
        }
    }

    public SwaggerParseResult readContents(String swaggerAsString, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult result = new SwaggerParseResult();
        if (swaggerAsString != null && !"".equals(swaggerAsString.trim())) {
            ObjectMapper mapper = this.getRightMapper(swaggerAsString);
            if (auth == null) {
                auth = new ArrayList<AuthorizationValue>();
            }
            if (options != null) {
                if (options.isResolve()) {
                    try {
                        OpenAPIDeserializer deserializer = new OpenAPIDeserializer();
                        JsonNode rootNode = mapper.readTree(swaggerAsString.getBytes());
                        result = deserializer.deserialize(rootNode);
                        OpenAPIResolver resolver = new OpenAPIResolver(result.getOpenAPI(), auth, null);
                        result.setOpenAPI(resolver.resolve());
                    }
                    catch (Exception e) {
                        result.setMessages(Arrays.asList(e.getMessage()));
                    }
                } else {
                    try {
                        JsonNode rootNode = mapper.readTree(swaggerAsString.getBytes());
                        result = new OpenAPIDeserializer().deserialize(rootNode);
                    }
                    catch (Exception e) {
                        result.setMessages(Arrays.asList(e.getMessage()));
                    }
                }
                if (options.isResolveFully()) {
                    result.setOpenAPI(new OpenAPIResolver(result.getOpenAPI(), auth, null).resolve());
                    new ResolverFully().resolveFully(result.getOpenAPI());
                }
            } else {
                try {
                    JsonNode rootNode = mapper.readTree(swaggerAsString.getBytes());
                    result = new OpenAPIDeserializer().deserialize(rootNode);
                }
                catch (Exception e) {
                    result.setMessages(Arrays.asList(e.getMessage()));
                }
            }
        } else {
            result.setMessages(Arrays.asList("No swagger supplied"));
        }
        return result;
    }

    protected List<SwaggerParserExtension> getExtensions() {
        ArrayList<SwaggerParserExtension> extensions = new ArrayList<SwaggerParserExtension>();
        ServiceLoader<SwaggerParserExtension> loader = ServiceLoader.load(SwaggerParserExtension.class);
        Iterator<SwaggerParserExtension> itr = loader.iterator();
        while (itr.hasNext()) {
            extensions.add(itr.next());
        }
        extensions.add(0, new OpenAPIV3Parser());
        return extensions;
    }

    protected List<AuthorizationValue> transform(List<AuthorizationValue> input) {
        if (input == null) {
            return null;
        }
        ArrayList<AuthorizationValue> output = new ArrayList<AuthorizationValue>();
        for (AuthorizationValue value : input) {
            AuthorizationValue v = new AuthorizationValue();
            v.setKeyName(value.getKeyName());
            v.setValue(value.getValue());
            v.setType(value.getType());
            output.add(v);
        }
        return output;
    }
}

