/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.utils;

import io.swagger.oas.inflector.models.ApiError;
import io.swagger.oas.inflector.processors.EntityProcessor;
import io.swagger.oas.inflector.processors.EntityProcessorFactory;
import io.swagger.oas.inflector.utils.ApiErrorUtils;
import io.swagger.oas.inflector.utils.ApiException;
import io.swagger.oas.inflector.utils.ContentTypeSelector;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class DefaultExceptionMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExceptionMapper.class);
    @Context
    Providers providers;
    @Context
    private HttpHeaders headers;

    public Response toResponse(Exception exception) {
        ContextResolver selector;
        ApiError error = this.createError(exception);
        int code = error.getCode();
        if (code != Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(error.getMessage(), (Throwable)exception);
            }
        } else {
            LOGGER.error(error.getMessage(), (Throwable)exception);
        }
        Response.ResponseBuilder builder = Response.status((int)code).entity((Object)error);
        MediaType responseMediaType = null;
        List<EntityProcessor> processors = EntityProcessorFactory.getProcessors();
        block0: for (EntityProcessor processor : processors) {
            if (responseMediaType != null) break;
            for (MediaType mt : this.headers.getAcceptableMediaTypes()) {
                LOGGER.debug("checking type " + mt.toString() + " against " + processor.getClass().getName());
                if (!processor.supports(mt)) continue;
                builder.type(mt);
                responseMediaType = mt;
                continue block0;
            }
        }
        if (responseMediaType == null) {
            for (EntityProcessor processor : processors) {
                MediaType mt;
                List<MediaType> supportedTypes = processor.getSupportedMediaTypes();
                if (supportedTypes.size() <= 0) continue;
                mt = supportedTypes.get(0);
                builder.type(mt);
                responseMediaType = mt;
                break;
            }
        }
        if (responseMediaType == null) {
            responseMediaType = MediaType.WILDCARD_TYPE;
        }
        if ((selector = this.providers.getContextResolver(ContentTypeSelector.class, responseMediaType)) != null) {
            ((ContentTypeSelector)selector.getContext(this.getClass())).apply(this.headers.getAcceptableMediaTypes(), builder);
        }
        return builder.build();
    }

    private ApiError createError(Exception exception) {
        if (exception instanceof ApiException) {
            return ((ApiException)exception).getError();
        }
        if (exception instanceof WebApplicationException) {
            WebApplicationException e = (WebApplicationException)exception;
            return new ApiError().code(e.getResponse().getStatus()).message(e.getMessage());
        }
        return ApiErrorUtils.createInternalError();
    }
}

