/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.oas.models.media;

import io.swagger.v3.oas.models.media.Schema;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IntegerSchema
extends Schema<Number> {
    private String type = "integer";
    private String format = "int32";

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public IntegerSchema type(String type) {
        this.type = type;
        return this;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public IntegerSchema format(String format) {
        this.format = format;
        return this;
    }

    public IntegerSchema _default(Number _default) {
        super.setDefault(_default);
        return this;
    }

    @Override
    protected Number cast(Object value) {
        if (value != null) {
            try {
                Number casted = NumberFormat.getInstance().parse(value.toString());
                if (casted.longValue() <= Integer.MAX_VALUE) {
                    return Integer.parseInt(value.toString());
                }
                return Long.parseLong(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public IntegerSchema _enum(List<Number> _enum) {
        this._enum = _enum;
        return this;
    }

    public IntegerSchema addEnumItem(Number _enumItem) {
        if (this._enum == null) {
            this._enum = new ArrayList();
        }
        this._enum.add(_enumItem);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerSchema integerSchema = (IntegerSchema)o;
        return Objects.equals(this.type, integerSchema.type) && Objects.equals(this.format, integerSchema.format) && Objects.equals(this._default, integerSchema._default) && Objects.equals(this._enum, integerSchema._enum) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.format, this._default, this._enum, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntegerSchema {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    _enum: ").append(this.toIndentedString(this._enum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

