/*
 * Decompiled with CFR 0.152.
 */
package io.staticcdn.sdk.gradle;

import io.staticcdn.sdk.client.StaticCdnClient;
import io.staticcdn.sdk.gradle.StaticCdnPluginExtension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;

public class OptimizeTask
extends DefaultTask {
    @TaskAction
    public void optimize() throws Exception {
        List<String> inputFileRelativePaths;
        StaticCdnPluginExtension extension = (StaticCdnPluginExtension)this.getProject().getExtensions().getByType(StaticCdnPluginExtension.class);
        if (extension.isSkipOptimize() || System.getProperty("skipOptimize") != null) {
            this.getLogger().warn("optimize skipped");
            return;
        }
        ArrayList<File> inputWwwRoots = new ArrayList<File>();
        if (extension.getInputWwwRoots() == null) {
            throw new RuntimeException("inputWwwRoots is required");
        }
        for (String path : extension.getInputWwwRoots()) {
            inputWwwRoots.add(new File(this.getProject().getProjectDir(), path));
        }
        File outputWwwRoot = null;
        if (extension.getOutputWwwRoot() != null) {
            outputWwwRoot = new File(this.getProject().getProjectDir(), extension.getOutputWwwRoot());
        }
        if ((inputFileRelativePaths = extension.getInputFileRelativePaths()) == null) {
            if (extension.getInputFilePathPatterns() != null) {
                inputFileRelativePaths = new ArrayList<String>();
            } else {
                throw new RuntimeException("you must set inputFileRelativePaths or inputFilePathPatterns");
            }
        }
        if (extension.getInputFilePathPatterns() != null) {
            for (File inputWwwRoot : inputWwwRoots) {
                if (!inputWwwRoot.isDirectory()) continue;
                for (File foundFile : FileUtils.listFiles((File)inputWwwRoot, null, (boolean)true)) {
                    String relativePath = foundFile.getAbsolutePath().substring(inputWwwRoot.getAbsolutePath().length());
                    relativePath = relativePath.replaceAll("\\\\", "/");
                    for (String filePathPattern : extension.getInputFilePathPatterns()) {
                        File originFile;
                        if (!relativePath.matches(filePathPattern) || inputFileRelativePaths.contains(relativePath) || (originFile = new File(foundFile.getParentFile(), extension.getOriginalFileNameSuffix() + foundFile.getName())).exists()) continue;
                        this.getLogger().debug("found file: " + foundFile.getAbsolutePath());
                        inputFileRelativePaths.add(relativePath);
                    }
                }
            }
        }
        if (inputFileRelativePaths.size() == 0) {
            throw new RuntimeException("no file found to optimize");
        }
        StaticCdnClient staticCdnClient = new StaticCdnClient(extension.getApiKey(), extension.getApiSecret());
        for (String filePath : inputFileRelativePaths) {
            staticCdnClient.optimize(inputWwwRoots, outputWwwRoot, filePath, extension.getOptimizerOptions(), extension.getOriginalFileNameSuffix(), extension.getRefsFileNameSuffix());
        }
    }
}

