/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.configuration;

import java.sql.Date;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.threeten.bp.LocalDate;
import org.threeten.bp.OffsetDateTime;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:application.properties"})})
public class SwaggerDocumentationConfig
extends WebSecurityConfigurerAdapter {
    private final String adminContextPath = "";
    protected static final Logger logger = LoggerFactory.getLogger(SwaggerDocumentationConfig.class);
    @Value(value="${CORSOrigins:http://localhost:8100}")
    public String CORSOrigins;
    @Value(value="${CORSMapping:/**}")
    public String CORSMapping;

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        logger.warn("Init CORS Config Origins: CORSOrigins " + this.CORSOrigins);
        logger.warn("Init CORS Config Mapping: CORSMapping " + this.CORSMapping);
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.addAllowedHeader("*");
        configuration.addExposedHeader("X-Content-Type-Options");
        configuration.addExposedHeader("WWW-Authenticate");
        configuration.addExposedHeader("Access-Control-Allow-Origin");
        configuration.addExposedHeader("Access-Control-Allow-Headers");
        configuration.setAllowedOrigins(Arrays.asList(this.CORSOrigins));
        configuration.setAllowedMethods(Arrays.asList("GET", "POST", "INSERT", "DELETE", "HEAD", "OPTIONS"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration(this.CORSMapping, configuration);
        return source;
    }

    protected void configure(HttpSecurity http) throws Exception {
        SavedRequestAwareAuthenticationSuccessHandler successHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        successHandler.setTargetUrlParameter("redirectTo");
        ((HttpSecurity)http.cors().and()).csrf().disable();
    }

    ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("Starter StackGen API").description("Starter StackGen API").license("AGPL 3.0").licenseUrl("https://www.gnu.org/licenses/agpl-3.0.html").termsOfServiceUrl("").version("1.0.4").contact(new Contact("", "", "info@StackGen.io")).build();
    }

    @Bean
    public Docket customImplementation() {
        return new Docket(DocumentationType.SWAGGER_2).select().apis(RequestHandlerSelectors.basePackage((String)"io.starter.StackGenUI.api")).build().directModelSubstitute(LocalDate.class, Date.class).directModelSubstitute(OffsetDateTime.class, java.util.Date.class).apiInfo(this.apiInfo());
    }
}

