/*
 * Decompiled with CFR 0.152.
 */
package io.starter.stackgen.web;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@Order(value=101)
@PropertySources(value={@PropertySource(value={"classpath:application.properties"})})
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(WebSecurityConfig.class);
    private final String adminContextPath = "";
    @Value(value="${io.starter.stackgen.CORSOrigins:localhost}")
    public String CORSOrigins;
    @Value(value="${io.starter.stackgen.CORSMapping:/**}")
    public String CORSMapping;

    protected void configure(HttpSecurity http) throws Exception {
        SavedRequestAwareAuthenticationSuccessHandler successHandler = new SavedRequestAwareAuthenticationSuccessHandler();
        successHandler.setTargetUrlParameter("redirectTo");
        successHandler.setDefaultTargetUrl("/");
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/assets/**"})).permitAll().antMatchers(new String[]{"/index.html"})).permitAll().anyRequest()).authenticated().and()).formLogin().loginPage("/index.html").successHandler((AuthenticationSuccessHandler)successHandler)).and()).logout().logoutUrl("/logout").and()).httpBasic().and()).cors().and()).csrf().csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).ignoringAntMatchers(new String[]{"/instances", "/actuator/**"});
    }

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        logger.warn("SGP-WSC: Initializing CORS Config Origins: CORSOrigins " + this.CORSOrigins);
        logger.warn("SGP-WSC: Initializing CORS Config Mapping: CORSMapping " + this.CORSMapping);
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Arrays.asList(this.CORSOrigins));
        configuration.setAllowedMethods(Arrays.asList("GET", "POST", "INSERT", "DELETE", "HEAD", "OPTIONS"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration(this.CORSMapping, configuration);
        return source;
    }
}

