/*
 * Decompiled with CFR 0.152.
 */
package io.starter.ignite.generator.react;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.starter.ignite.generator.ReactConfigurator;
import io.starter.ignite.generator.annotations.StackgenModelProperty;
import io.starter.ignite.generator.react.EntityObject;
import io.starter.ignite.model.DataField;
import io.starter.ignite.security.securefield.SecureField;
import io.starter.toolkit.StringTool;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppEntityObject {
    private static final Logger logger = LoggerFactory.getLogger(AppEntityObject.class);
    ReactConfigurator config;
    private static final Class<SecureField> SECURE_ANNOTATION_CLASS = SecureField.class;
    private static final Class<DataField> DATA_ANNOTATION_CLASS = DataField.class;
    private static final Class<JsonProperty> FIELD_ANNOTATION_CLASS = JsonProperty.class;
    private static final Class<StackgenModelProperty> ANNOTATION_CLASS = StackgenModelProperty.class;
    public String GENERATED_MESSAGE = "NOTE: THIS IS A STACKGEN GENERATED FILE: MAY BE OVERWRITTEN";
    public String LICENSE = "GPL 3.0";
    public String COMPANY_INFO = "Starter Inc.";
    public String CONTACT_INFO = "support@stackgen.io";
    public String appname;
    public String serverhost;
    public String serverport;
    public String objectname;
    public String objectnamevarname;
    public String objectnameupper;
    public List<Variable> variables = new ArrayList<Variable>();
    public List<EntityObject> dataobjects = new ArrayList<EntityObject>();
    public String componentspec;

    private static Annotation getAnnotationForMethod(Method m, Class<?> lookingFor) {
        Annotation[] decl;
        Annotation[] annotationArray = decl = m.getDeclaredAnnotations();
        int n = decl.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation c = annotationArray[n2];
            Class<? extends Annotation> tn = c.annotationType();
            if (tn.toString().equals(lookingFor.toString())) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public AppEntityObject(String app, Class<?> cx, ReactConfigurator cfg) {
        this.config = cfg;
        this.serverhost = this.config.defaultHostname;
        this.serverport = this.config.defaultPort;
        this.appname = app;
        this.objectname = cx.getName().substring(cx.getName().lastIndexOf(".") + 1);
        this.objectnameupper = this.objectname.toUpperCase();
        this.objectnamevarname = String.valueOf(String.valueOf(this.objectname.charAt(0)).toLowerCase()) + this.objectname.substring(1);
        Stream.of(cx.getDeclaredMethods()).filter(s -> {
            Annotation decl = AppEntityObject.getAnnotationForMethod(s, ANNOTATION_CLASS);
            return decl != null;
        }).forEach(s -> {
            try {
                this.processMethod((Method)s, cx);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.error("AppEntityObject is invalid: " + s.toString());
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            if (!this.isValid()) {
                logger.warn("AppEntityObject is invalid: " + s.toString());
            }
        });
        Stream.of(cx.getDeclaredFields()).filter(s -> true).forEach(s -> {
            if (!this.isValid()) {
                logger.warn("AppEntityObject is invalid: " + s.toString());
            }
        });
    }

    private void processField(Field f) {
        try {
            SecureField fa = f.getAnnotation(SECURE_ANNOTATION_CLASS);
            JsonProperty jf = f.getAnnotation(FIELD_ANNOTATION_CLASS);
            f.getAnnotation(DATA_ANNOTATION_CLASS);
            if (jf != null) {
                jf.value();
            } else {
                Integer.valueOf(fa.strength());
            }
        }
        catch (SecurityException securityException) {
            logger.error("FIELD ERROR: " + f.getName());
        }
    }

    public static Object getAPIAnnotatedValue(Method method, String vName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Annotation ano = AppEntityObject.getAnnotationForMethod(method, ANNOTATION_CLASS);
        if (ano == null) {
            return null;
        }
        return ano.annotationType().getMethod(vName, new Class[0]).invoke((Object)ano, new Object[0]);
    }

    private void processMethod(Method s, Class<?> cx) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        block39: {
            boolean hidden;
            Object val;
            block38: {
                Class<?> ptype = s.getReturnType();
                Class<?>[] allClasses = cx.getDeclaredClasses();
                Class<?> enumClass = null;
                String enumOptions = "";
                Class<?>[] classArray = allClasses;
                int n = allClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> c = classArray[n2];
                    if (c.getTypeName().equals(ptype.getTypeName())) {
                        Field[] allFields;
                        enumClass = c;
                        Field[] fieldArray = allFields = c.getDeclaredFields();
                        int n3 = allFields.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Field field = fieldArray[n4];
                            if (!field.getName().equals("value") && !field.getName().contains("$VALUES")) {
                                enumOptions = String.valueOf(enumOptions) + "<option>" + field.getName() + "</option> \r\n";
                            }
                            ++n4;
                        }
                        enumOptions = String.valueOf(enumOptions) + "</Field> \r\n";
                    }
                    ++n2;
                }
                val = AppEntityObject.getAPIAnnotatedValue(s, "example");
                hidden = (Boolean)AppEntityObject.getAPIAnnotatedValue(s, "hidden");
                if (hidden || val == null) break block38;
                val = this.getReturnValue(s) != null ? this.getReturnValue(s) : "";
                String name = AppEntityObject.getAPIAnnotatedValue(s, "name").toString();
                if (name.equals("")) {
                    name = s.getName().replaceAll("get", "");
                }
                if (this.config.HIDE_FIELD_LIST.contains(name = StringTool.getLowerCaseFirstLetter((String)name))) break block39;
                Variable v = new Variable(name, val);
                try {
                    Field f = s.getDeclaringClass().getDeclaredField(name);
                    String tf = f.getType().toString();
                    v.variableType = tf.substring(tf.lastIndexOf(".") + 1).toLowerCase();
                    v.variableFieldYupSchemaType = String.valueOf(name) + " : yup.";
                    switch (v.variableType) {
                        case "string": {
                            v.variableFieldYupSchemaType = String.valueOf(v.variableFieldYupSchemaType) + "string()";
                            if ((Integer)AppEntityObject.getAPIAnnotatedValue(s, "maxLength") > 256) {
                                v.variableFieldType = "as=\"textarea\"";
                                break;
                            }
                            v.variableFieldType = "type=\"text\"";
                            break;
                        }
                        case "boolean": {
                            v.variableFieldType = "type=\"checkbox\"";
                            v.variableFieldYupSchemaType = String.valueOf(v.variableFieldYupSchemaType) + "bool()";
                            break;
                        }
                        case "integer": {
                            v.variableFieldYupSchemaType = String.valueOf(v.variableFieldYupSchemaType) + "number()";
                            v.variableFieldType = "type=\"text\"";
                            break;
                        }
                        case "float": {
                            v.variableFieldYupSchemaType = String.valueOf(v.variableFieldYupSchemaType) + "number()";
                            v.variableFieldType = "type=\"text\"";
                            break;
                        }
                        case "double": {
                            v.variableFieldYupSchemaType = String.valueOf(v.variableFieldYupSchemaType) + "number()";
                            v.variableFieldType = "type=\"text\"";
                            break;
                        }
                        case "long": {
                            v.variableFieldYupSchemaType = String.valueOf(v.variableFieldYupSchemaType) + "number()";
                            v.variableFieldType = "type=\"text\"";
                            break;
                        }
                        case "hidden": {
                            v.variableFieldYupSchemaType = String.valueOf(v.variableFieldYupSchemaType) + "string()";
                            v.variableFieldType = "type=\"hidden\"";
                            break;
                        }
                        default: {
                            v.variableFieldYupSchemaType = "";
                            v.variableFieldType = "type=\"text\"";
                        }
                    }
                    if (enumClass != null) {
                        logger.info("Setting Enum Options: " + enumOptions);
                        v.variableFieldType = "as=\"select\"";
                        v.enumOptions = enumOptions;
                        v.enumClass = enumClass;
                        v.fieldEndTag = ">";
                    }
                    if (!v.variableFieldYupSchemaType.equals("")) {
                        if (((Boolean)AppEntityObject.getAPIAnnotatedValue(s, "required")).booleanValue()) {
                            v.variableFieldYupSchemaType = String.valueOf(v.variableFieldYupSchemaType) + ".required()";
                        }
                        v.variableFieldYupSchemaType = String.valueOf(v.variableFieldYupSchemaType) + ",";
                    }
                }
                catch (NoSuchFieldException | SecurityException e1) {
                    e1.printStackTrace();
                    throw new RuntimeException("ERROR in AppEntityObject.processMethod : " + s.toGenericString() + " :" + "ERROR_AEO_PM_" + name);
                }
                v.defaultValue = AppEntityObject.getAPIAnnotatedValue(s, "example").toString();
                v.description = AppEntityObject.getAPIAnnotatedValue(s, "value").toString();
                v.required = (Boolean)AppEntityObject.getAPIAnnotatedValue(s, "required") != false ? "required" : "";
                v.hidden = hidden ? "hidden" : "";
                this.variables.add(v);
                break block39;
            }
            if (hidden) {
                logger.warn("Skipping Hidden Field: " + s.toGenericString() + " :" + val);
            } else {
                logger.error("Skipping Field Possible Error: " + s.toGenericString() + " :" + val);
            }
        }
    }

    private String handleStackGenExtensions(Variable v, StackgenModelProperty apia) {
        String fld = apia.dataField();
        apia.secureField();
        return fld;
    }

    private Object getReturnValue(Method s) {
        Long ret = null;
        switch (s.getReturnType().toString()) {
            case "long": {
                ret = new Long(0L);
                break;
            }
            case "Long": {
                ret = new Long(0L);
            }
        }
        return ret;
    }

    public boolean isValid() {
        if (this.appname == null) {
            return false;
        }
        if (this.objectname == null) {
            return false;
        }
        return this.objectnameupper != null;
    }

    public String toString() {
        String sbout = "AppEntityObject: " + this.objectname + "\r\n";
        for (Variable v : this.variables) {
            sbout = String.valueOf(sbout) + v.toString() + "\r\n";
        }
        return sbout;
    }

    public static String convertCamelToFriendly(String camelin) {
        char[] chars = camelin.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            if (Character.isUpperCase(chars[i])) {
                if (i > 0 && i + 1 < chars.length && Character.isLowerCase(chars[i - 1])) {
                    buf.append(" ");
                    buf.append(Character.toUpperCase(chars[i]));
                }
            } else if (i == 0) {
                buf.append(Character.toUpperCase(chars[i]));
            } else {
                buf.append(Character.toLowerCase(chars[i]));
            }
            ++i;
        }
        return buf.toString();
    }

    public static class Variable {
        public Class enumClass = null;
        public String enumOptions = "";
        public String fieldEndTag = "/>";
        public String required = "";
        public String hidden = "";
        public Object variableval;
        public String variablename;
        public String validationString;
        public String defaultValue;
        public String description;
        public String variableType = "";
        public String variableFieldType = "";
        public String variableFieldYupSchemaType = "";
        public String secure;
        public String dataField;
        public String componentView;
        public String componentList;
        public String componentEdit;
        public String componentAdd;
        public String componentLookup;
        public String displayName;

        Variable(String variablename, Object variableval) {
            this.variablename = variablename;
            this.displayName = AppEntityObject.convertCamelToFriendly(variablename);
            this.variableval = variableval;
        }

        public String toString() {
            return String.valueOf(this.variablename) + " : " + this.variableval;
        }
    }
}

