/*
 * Decompiled with CFR 0.152.
 */
package io.starter.ignite.generator;

import io.starter.ignite.generator.Gen;
import io.starter.ignite.generator.IgniteException;
import io.starter.ignite.generator.Main;
import io.starter.ignite.generator.ReactConfigurator;
import io.starter.ignite.generator.ReactGen;
import io.starter.ignite.generator.StackGenConfigurator;
import java.security.NoSuchAlgorithmException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;

@SpringBootApplication
@Order(value=-2147483648)
public class ReactGenerator
extends Main
implements CommandLineRunner {
    protected static final Logger logger = LoggerFactory.getLogger(ReactGenerator.class);
    private static String[][] sf = new String[][]{{"/src/resources/templates/application.yml", "/src/main/resources/application.yml"}, {"/src/resources/templates/log4j.properties", "/src/main/resources/log4j.properties"}, {"/logs/logfile_placeholder.txt", "/logs/logfile_placeholder.txt"}, {"/src/main/java/io/starter/spring/boot/stackgen-pro.txt", "/src/main/java/io/starter/spring/boot/stackgen-pro.txt"}};

    public ReactGenerator(StackGenConfigurator cfg) {
        Gen.config = cfg;
    }

    public static void main(String[] args) throws Exception {
        Main.checkLog4j();
        if (args == null) {
            args = new String[]{};
        }
        SpringApplication app = new SpringApplication(new Class[]{ReactGenerator.class});
        app.setWebApplicationType(WebApplicationType.NONE);
        ConfigurableApplicationContext context = app.run(args);
        context.close();
        System.exit(0);
    }

    public void generateApp(JSONObject cfg) throws Exception {
        try {
            Gen.config = (ReactConfigurator)ReactConfigurator.configureFromJSON((JSONObject)cfg, (StackGenConfigurator)Gen.config);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            logger.error("Copying config values from JSON to Swagger Config failed while starting App Generation");
            e.printStackTrace();
        }
        this.generateStack(Gen.config);
    }

    public void run(String ... args) throws IllegalArgumentException, IllegalAccessException, NoSuchAlgorithmException {
        args = new String[]{System.getProperty("schemaFile")};
        super.run(args);
        this.copyStaticFiles(Main.staticFiles);
        ReactGen gx = new ReactGen();
        if (!gx.getConfig().skipReactGen) {
            this.copyStaticFiles(sf);
            try {
                gx.generateReact();
            }
            catch (Exception e) {
                throw new IgniteException(e.toString());
            }
        } else {
            logger.info("Skipping React Generation");
        }
    }
}

