/*
 * Decompiled with CFR 0.152.
 */
package io.starter.ignite.generator;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.squareup.javapoet.MethodSpec;
import io.starter.ignite.generator.Gen;
import io.starter.ignite.generator.Generator;
import io.starter.ignite.generator.ReactConfigurator;
import io.starter.ignite.generator.StackGenConfigurator;
import io.starter.ignite.generator.react.AppEntityObject;
import io.starter.ignite.generator.react.EntityObject;
import io.starter.ignite.util.FileUtil;
import io.starter.toolkit.StringTool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class ReactGen
extends Gen
implements Generator {
    protected static final Logger logger = LoggerFactory.getLogger(ReactGen.class);
    static ReactConfigurator config = new ReactConfigurator();

    @Bean
    public StackGenConfigurator getConfig() {
        return config;
    }

    private static void export(ReactGen gen) throws IOException {
        logger.info("Exporting: " + ReactGen.config.REACT_EXPORT_FOLDER + ReactGen.config.REACT_APP_NAME + " to: " + ReactGen.config.REACT_APP_OUTPUT_FOLDER);
        FileUtil.copyFolder((String)(String.valueOf(ReactGen.config.REACT_EXPORT_FOLDER) + ReactGen.config.REACT_APP_NAME), (String)(String.valueOf(ReactGen.config.REACT_APP_OUTPUT_FOLDER) + ReactGen.config.REACT_APP_NAME));
    }

    void generateEntitiesFromModelFolder(ReactGen gen) throws Exception {
        logger.info("Iterate Data Object Entities and create React App Entity Classes...");
        String[] modelFiles = this.getModelFileNames();
        URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(config.getJavaGenSourceFolder()).toURI().toURL(), new File(config.getJavaGenResourcesFolder()).toURI().toURL()});
        String[] stringArray = modelFiles;
        int n = modelFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String mf = stringArray[n2];
            String cn = mf.substring(0, mf.indexOf("."));
            cn = String.valueOf(config.getIgniteModelPackage()) + "." + cn;
            logger.info("Loading Classes from ModelFile: " + cn);
            ReactGen.createAppEntities(gen, classLoader.loadClass(cn));
            ++n2;
        }
        classLoader.close();
    }

    private static void createAppEntities(ReactGen gen, Class<?> forName) {
        if (gen == null) {
            throw new IllegalStateException("No ReactGen context in createAppEntities");
        }
        if (ReactGen.config.REACT_APP_NAME == null) {
            throw new IllegalStateException("No AppName in createAppEntities");
        }
        if (forName == null) {
            throw new IllegalStateException("No Class defined in createAppEntities");
        }
        AppEntityObject ap = new AppEntityObject(ReactGen.config.REACT_APP_NAME, forName, config);
        ReactGen.config.REACT_DATA_OBJECTS.add(ap);
    }

    public void generateReact() throws Exception {
        ArrayList<String> alreadyAdded = new ArrayList<String>();
        ReactGen gen = new ReactGen();
        this.generateEntitiesFromModelFolder(gen);
        File[] templateFiles = this.getSourceFilesInFolder(new File(ReactGen.config.REACT_TEMPLATE_FOLDER), ReactGen.config.FOLDER_SKIP_LIST);
        ArrayList<EntityObject> objnames = new ArrayList<EntityObject>();
        int i = 0;
        for (AppEntityObject oa : ReactGen.config.REACT_DATA_OBJECTS) {
            objnames.add(new EntityObject(oa.objectname, i++));
        }
        File[] fileArray = templateFiles;
        int n = templateFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File o = fileArray[n2];
            String fname = ((Object)o).toString();
            String shortName = fname.substring(fname.lastIndexOf("/") + 1);
            if (ReactGen.shouldParse(shortName)) {
                for (AppEntityObject aeo : ReactGen.config.REACT_DATA_OBJECTS) {
                    String foutp = StringTool.replaceText((String)fname, (String)"objectName", (String)aeo.objectname);
                    aeo.dataobjects = objnames;
                    if (alreadyAdded.contains(foutp)) continue;
                    ReactGen.generateFromTemplate(aeo, fname, foutp);
                    alreadyAdded.add(foutp);
                }
            } else {
                ReactGen.generateFromTemplate((Object)gen, fname, null);
            }
            ++n2;
        }
        ReactGen.export(gen);
        logger.info("Done processing " + ReactGen.config.REACT_DATA_OBJECTS.size() + " React Objects");
    }

    private static boolean shouldParse(String shortName) {
        return true;
    }

    private static void generateFromTemplate(Object gen, String fname, String multifile) throws IOException, FileNotFoundException {
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        String foutp = null;
        foutp = multifile != null ? StringTool.replaceText((String)multifile, (String)ReactGen.config.REACT_TEMPLATE_SOURCES_FOLDER, (String)(String.valueOf(ReactGen.config.REACT_EXPORT_FOLDER) + ReactGen.config.REACT_APP_NAME)) : StringTool.replaceText((String)fname, (String)ReactGen.config.REACT_TEMPLATE_SOURCES_FOLDER, (String)(String.valueOf(ReactGen.config.REACT_EXPORT_FOLDER) + ReactGen.config.REACT_APP_NAME));
        File fout = new File(foutp);
        File finp = new File(fname);
        fout.mkdirs();
        if (fout.isDirectory()) {
            fout.delete();
        }
        if (!fout.exists()) {
            fout.mkdirs();
            fout.delete();
        }
        if (!finp.isDirectory()) {
            try {
                FileReader fread = new FileReader(finp);
                fout.delete();
                fout.createNewFile();
                FileWriter fwriter = new FileWriter(fout);
                Mustache reactmf = mf.compile((Reader)fread, ReactGen.config.REACT_APP_OUTPUT_FOLDER);
                reactmf.execute((Writer)fwriter, gen);
                ((Writer)fwriter).flush();
            }
            catch (Exception e) {
                logger.error("Failed to generate from template: " + e);
            }
        }
    }

    public Object createSetter(Field fld) {
        String fieldName = fld.getName();
        if (fieldName.startsWith("ajc$")) {
            return null;
        }
        String fldName = StringTool.getUpperCaseFirstLetter((String)fieldName);
        String ret = fldName = "get" + fldName;
        return ret;
    }

    public Object createAccessor(Field f) {
        return null;
    }

    public Object createMember(Field f) {
        return null;
    }

    public void generate(String className, List<Object> fieldList, List<MethodSpec> getters, List<MethodSpec> setters) throws Exception {
    }
}

