package io.starter.stackgentest.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import io.starter.ignite.generator.annotations.StackgenModelProperty;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.*;

import com.fasterxml.jackson.annotation.JsonInclude;

import io.starter.ignite.model.DataModelObject;

/**
 * Generated by Starter StackGen: http://stackgen.io Powered by Swagger Codegen:
 * http://swagger.io
 * 
 * Generator version: (2.4.8)
 * 
 * Template file: JavaSpring/pojo.mustache
 * 
 * Description: User
 */

@JsonInclude(JsonInclude.Include.NON_EMPTY)

@javax.annotation.Generated(value = "io.starter.ignite.generator.swagger.languages.StackGenSpringCodegen", date = "2020-01-25T10:25:56.324-08:00")

public class User implements io.starter.ignite.model.DataModelObject {

	/**
	 * API status as of last check
	 */
	public enum BOOEnum {
		NOOGIE("available"),

		HEADBUTT("runtime-error"),

		PURPLENURPLE("compilation-error"),

		TICKLE("locked");

		private String value;

		BOOEnum(String value) {
			this.value = value;
		}

		@JsonValue
		public String getValue() {
			return value;
		}

		@Override
		public String toString() {
			return String.valueOf(value);
		}

		@JsonCreator
		public static BOOEnum fromValue(String text) {
			for (BOOEnum b : BOOEnum.values()) {
				if (String.valueOf(b.value).equalsIgnoreCase(text)) {
					return b;
				}
			}
			return null;
		}
	}

	@JsonProperty("boostat")
	public BOOEnum boostat = null;

	public BOOEnum getBoostat() {
		return boostat;
	}

	public void setBoostat(BOOEnum boostat) {
		this.boostat = boostat;
	}

	/**
	 * API status as of last check
	 */
	public enum StatusEnum {
		AVAILABLE("available"),

		RUNTIME_ERROR("runtime-error"),

		COMPILATION_ERROR("compilation-error"),

		LOCKED("locked");

		private String value;

		StatusEnum(String value) {
			this.value = value;
		}

		@JsonValue
		public String getValue() {
			return value;
		}

		@Override
		public String toString() {
			return String.valueOf(value);
		}

		@JsonCreator
		public static StatusEnum fromValue(String text) {
			for (StatusEnum b : StatusEnum.values()) {
				if (String.valueOf(b.value).equalsIgnoreCase(text)) {
					return b;
				}
			}
			return null;
		}
	}

	@JsonProperty("status")
	public StatusEnum status = null;

	@StackgenModelProperty(name = "status", value = "API status as of last check")
	public StatusEnum getStatus() {
		return status;
	}

	public void setStatus(StatusEnum status) {
		this.status = status;
	}

// the Starter StackGen Annotations
	@io.starter.ignite.security.securefield.SecureField(enabled = true, strength = 5)
	@JsonProperty("firstName")
	public String firstName = null;

// the Starter StackGen Annotations
	@io.starter.ignite.security.securefield.SecureField(enabled = true, strength = 5)
	@JsonProperty("lastName")
	public String lastName = null;

// the Starter StackGen Annotations
	@io.starter.ignite.security.securefield.SecureField(enabled = true, strength = 5)
	@JsonProperty("governmentId")
	public String governmentId = null;

	@JsonProperty("userName")
	public String userName = null;

// the Starter StackGen Annotations
	@io.starter.ignite.security.securefield.SecureField(enabled = true, type = io.starter.ignite.security.securefield.SecureField.Type.HASHED)
	@JsonProperty("password")
	public String password = null;

// the Starter StackGen Annotations
	@io.starter.ignite.security.securefield.SecureField(enabled = true, strength = 5)
	@JsonProperty("fingerprint")
	public String fingerprint = null;

	@JsonProperty("homePage")
	public String homePage = null;

// the Starter StackGen Annotations
	@io.starter.ignite.security.securefield.SecureField(enabled = true, strength = 5)
	@JsonProperty("email")
	public String email = null;

	@JsonProperty("social")
	public String social = null;

	@JsonProperty("credentialNonExpired")
	public Boolean credentialNonExpired = true;

	@JsonProperty("accountEnabled")
	public Boolean accountEnabled = true;

	@JsonProperty("accountNonLocked")
	public Boolean accountNonLocked = true;

	@JsonProperty("accountNonExpired")
	public Boolean accountNonExpired = false;

	@JsonProperty("authorities")
	public List<String> authorities = null;

	@JsonProperty("keyVersion")
	public Long keyVersion = null;

	@JsonProperty("keySpec")
	public String keySpec = "dev";

	@JsonProperty("ownerId")
	public Long ownerId = null;

	@JsonProperty("createdDate")
	public OffsetDateTime createdDate = null;

	@JsonProperty("modifiedDate")
	public OffsetDateTime modifiedDate = null;

	@JsonProperty("id")
	public Long id = null;

	public User firstName(String firstName) {
		this.firstName = firstName;
		return this;
	}

	/**
	 * first name of person (encrypted)
	 * 
	 * @return firstName
	 **/

	@StackgenModelProperty(name = "firstName", example = "Karena", value = "first name of person (encrypted)")
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public User lastName(String lastName) {
		this.lastName = lastName;
		return this;
	}

	/**
	 * last name of person (encrypted)
	 * 
	 * @return lastName
	 **/

	@StackgenModelProperty(name = "lastName", example = "Jones", value = "last name of person (encrypted)")
	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public User governmentId(String governmentId) {
		this.governmentId = governmentId;
		return this;
	}

	/**
	 * a 10 digit government ID (encrypted)
	 * 
	 * @return governmentId
	 **/

	@Size(min = 10, max = 10)
	@StackgenModelProperty(name = "governmentId", example = "1112233334", minLength = 10, maxLength = 10, value = "a 10 digit government ID (encrypted)")
	public String getGovernmentId() {
		return governmentId;
	}

	public void setGovernmentId(String governmentId) {
		this.governmentId = governmentId;
	}

	public User userName(String userName) {
		this.userName = userName;
		return this;
	}

	/**
	 * Get userName
	 * 
	 * @return userName
	 **/

	@StackgenModelProperty(name = "userName", example = "Sparky", value = "")
	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public User password(String password) {
		this.password = password;
		return this;
	}

	/**
	 * Get password
	 * 
	 * @return password
	 **/
	@NotNull

	@Size(min = 10)
	@StackgenModelProperty(name = "password", example = "HardToGuess1980", minLength = 10, required = true, value = "")
	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public User fingerprint(String fingerprint) {
		this.fingerprint = fingerprint;
		return this;
	}

	/**
	 * Get fingerprint
	 * 
	 * @return fingerprint
	 **/

	@StackgenModelProperty(name = "fingerprint", example = "DK$DFSJaraDD", value = "")
	public String getFingerprint() {
		return fingerprint;
	}

	public void setFingerprint(String fingerprint) {
		this.fingerprint = fingerprint;
	}

	public User homePage(String homePage) {
		this.homePage = homePage;
		return this;
	}

	/**
	 * Get homePage
	 * 
	 * @return homePage
	 **/

	@StackgenModelProperty(name = "homePage", example = "https://www.acme-corp.com", value = "")
	public String getHomePage() {
		return homePage;
	}

	public void setHomePage(String homePage) {
		this.homePage = homePage;
	}

	public User email(String email) {
		this.email = email;
		return this;
	}

	/**
	 * the main email address for the user (encrypted)
	 * 
	 * @return email
	 **/
	@NotNull

	@StackgenModelProperty(name = "email", example = "wiley.coyote@acme-corp.com", required = true, value = "the main email address for the user  (encrypted)")
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public User social(String social) {
		this.social = social;
		return this;
	}

	/**
	 * Get social
	 * 
	 * @return social
	 **/

	@StackgenModelProperty(name = "social", example = "https://twitter.com/StackGen", value = "")
	public String getSocial() {
		return social;
	}

	public void setSocial(String social) {
		this.social = social;
	}

	public User credentialNonExpired(Boolean credentialNonExpired) {
		this.credentialNonExpired = credentialNonExpired;
		return this;
	}

	/**
	 * Spring Security User field whether the user&#39;s login credentials have
	 * expired
	 * 
	 * @return credentialNonExpired
	 **/

	@StackgenModelProperty(name = "credentialNonExpired", value = "Spring Security User field whether the user's login credentials have expired")
	public Boolean getCredentialNonExpired() {
		return credentialNonExpired;
	}

	public void setCredentialNonExpired(Boolean credentialNonExpired) {
		this.credentialNonExpired = credentialNonExpired;
	}

	public User accountEnabled(Boolean accountEnabled) {
		this.accountEnabled = accountEnabled;
		return this;
	}

	/**
	 * Spring Security User field whether the user account is enabled
	 * 
	 * @return accountEnabled
	 **/

	@StackgenModelProperty(name = "accountEnabled", value = "Spring Security User field whether the user account is enabled")
	public Boolean getAccountEnabled() {
		return accountEnabled;
	}

	public void setAccountEnabled(Boolean accountEnabled) {
		this.accountEnabled = accountEnabled;
	}

	public User accountNonLocked(Boolean accountNonLocked) {
		this.accountNonLocked = accountNonLocked;
		return this;
	}

	/**
	 * Spring Security User field whether the user account is locked
	 * 
	 * @return accountNonLocked
	 **/

	@StackgenModelProperty(name = "accountNonLocked", value = "Spring Security User field whether the user account is locked")
	public Boolean getAccountNonLocked() {
		return accountNonLocked;
	}

	public void setAccountNonLocked(Boolean accountNonLocked) {
		this.accountNonLocked = accountNonLocked;
	}

	public User accountNonExpired(Boolean accountNonExpired) {
		this.accountNonExpired = accountNonExpired;
		return this;
	}

	/**
	 * Spring Security User field whether the user account has expired
	 * 
	 * @return accountNonExpired
	 **/

	@StackgenModelProperty(name = "accountNonExpired", value = "Spring Security User field whether the user account has expired")
	public Boolean getAccountNonExpired() {
		return accountNonExpired;
	}

	public void setAccountNonExpired(Boolean accountNonExpired) {
		this.accountNonExpired = accountNonExpired;
	}

	public User authorities(List<String> authorities) {
		this.authorities = authorities;
		return this;
	}

	public User addAuthoritiesItem(String authoritiesItem) {
		if (this.authorities == null) {
			this.authorities = new ArrayList<>();
		}
		this.authorities.add(authoritiesItem);
		return this;
	}

	/**
	 * Spring Security User representation of the granted authority (or
	 * &lt;code&gt;null&lt;/code&gt; if the granted authority cannot be expressed as
	 * a &lt;code&gt;String&lt;/code&gt; with sufficient precision).
	 * 
	 * @return authorities
	 **/

	@StackgenModelProperty(name = "authorities", value = "Spring Security User representation of the granted authority (or <code>null</code> if the granted authority cannot be expressed as a <code>String</code> with sufficient precision).")
	public List<String> getAuthorities() {
		return authorities;
	}

	public void setAuthorities(List<String> authorities) {
		this.authorities = authorities;
	}

	public User keyVersion(Long keyVersion) {
		this.keyVersion = keyVersion;
		return this;
	}

	/**
	 * The version of the SecureField key used to crypt this row (generated column)
	 * 
	 * @return keyVersion
	 **/

	@StackgenModelProperty(name = "keyVersion", value = "The version of the SecureField key used to crypt this row (generated column)")
	public Long getKeyVersion() {
		return keyVersion;
	}

	public void setKeyVersion(Long keyVersion) {
		this.keyVersion = keyVersion;
	}

	/**
	 * The spec of the SecureField key used to crypt this row (generated column)
	 * 
	 * @return keySpec
	 **/

	@StackgenModelProperty(name = "keySpec", example = "keySource:system", value = "The spec of the SecureField key used to crypt this row (generated column)")
	public String getKeySpec() {
		return keySpec;
	}

	public User ownerId(Long ownerId) {
		this.ownerId = ownerId;
		return this;
	}

	/**
	 * The ID of the user that owns this data (generated column)
	 * 
	 * @return ownerId
	 **/

	@StackgenModelProperty(name = "ownerId", value = "The ID of the user that owns this data (generated column)")
	public Long getOwnerId() {
		return ownerId;
	}

	public void setOwnerId(Long ownerId) {
		this.ownerId = ownerId;
	}

	/**
	 * The created date for this record/object (generated column)
	 * 
	 * @return createdDate
	 **/

	@Valid

	@StackgenModelProperty(name = "createdDate", value = "The created date for this record/object (generated column)")
	public OffsetDateTime getCreatedDate() {
		return createdDate;
	}

	public User modifiedDate(OffsetDateTime modifiedDate) {
		this.modifiedDate = modifiedDate;
		return this;
	}

	/**
	 * The last-modified date for this record/object (generated column)
	 * 
	 * @return modifiedDate
	 **/

	@Valid

	@StackgenModelProperty(name = "modifiedDate", value = "The last-modified date for this record/object (generated column)")
	public OffsetDateTime getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(OffsetDateTime modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	/**
	 * Primary Key for Object (generated column)
	 * 
	 * @return id
	 **/

	@StackgenModelProperty(name = "id", value = "Primary Key for Object (generated column)")
	public Long getId() {
		return id;
	}

	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		User user = (User) o;
		return Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName)
				&& Objects.equals(this.governmentId, user.governmentId) && Objects.equals(this.userName, user.userName)
				&& Objects.equals(this.password, user.password) && Objects.equals(this.fingerprint, user.fingerprint)
				&& Objects.equals(this.homePage, user.homePage) && Objects.equals(this.email, user.email)
				&& Objects.equals(this.social, user.social)
				&& Objects.equals(this.credentialNonExpired, user.credentialNonExpired)
				&& Objects.equals(this.accountEnabled, user.accountEnabled)
				&& Objects.equals(this.accountNonLocked, user.accountNonLocked)
				&& Objects.equals(this.accountNonExpired, user.accountNonExpired)
				&& Objects.equals(this.authorities, user.authorities)
				&& Objects.equals(this.keyVersion, user.keyVersion) && Objects.equals(this.keySpec, user.keySpec)
				&& Objects.equals(this.ownerId, user.ownerId) && Objects.equals(this.createdDate, user.createdDate)
				&& Objects.equals(this.modifiedDate, user.modifiedDate) && Objects.equals(this.id, user.id);
	}

	@Override
	public int hashCode() {
		return Objects.hash(firstName, lastName, governmentId, userName, password, fingerprint, homePage, email, social,
				credentialNonExpired, accountEnabled, accountNonLocked, accountNonExpired, authorities, keyVersion,
				keySpec, ownerId, createdDate, modifiedDate, id);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class User {\n");

		sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
		sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
		sb.append("    governmentId: ").append(toIndentedString(governmentId)).append("\n");
		sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
		sb.append("    password: ").append(toIndentedString(password)).append("\n");
		sb.append("    fingerprint: ").append(toIndentedString(fingerprint)).append("\n");
		sb.append("    homePage: ").append(toIndentedString(homePage)).append("\n");
		sb.append("    email: ").append(toIndentedString(email)).append("\n");
		sb.append("    social: ").append(toIndentedString(social)).append("\n");
		sb.append("    credentialNonExpired: ").append(toIndentedString(credentialNonExpired)).append("\n");
		sb.append("    accountEnabled: ").append(toIndentedString(accountEnabled)).append("\n");
		sb.append("    accountNonLocked: ").append(toIndentedString(accountNonLocked)).append("\n");
		sb.append("    accountNonExpired: ").append(toIndentedString(accountNonExpired)).append("\n");
		sb.append("    authorities: ").append(toIndentedString(authorities)).append("\n");
		sb.append("    keyVersion: ").append(toIndentedString(keyVersion)).append("\n");
		sb.append("    keySpec: ").append(toIndentedString(keySpec)).append("\n");
		sb.append("    ownerId: ").append(toIndentedString(ownerId)).append("\n");
		sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
		sb.append("    modifiedDate: ").append(toIndentedString(modifiedDate)).append("\n");
		sb.append("    id: ").append(toIndentedString(id)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	/**
	 * Starter StackGen DataModelObject impl.
	 */
	@Override
	public DataModelObject getDelegate() {
		return null; // no delegate here
	}

	/**
	 * Starter StackGen JSON method
	 */
	@Override
	public String toJSON() {
		String ret = new org.json.JSONObject(this).toString();
		ret = ret.replace("\\\"", "\"");
		ret = ret.replace("\"}\"", "\"}");
		return ret;
	}

	/**
	 * Convert the given object to string with each line indented by 4 spaces
	 * (except the first line).
	 */
	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}

}
