/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import com.google.common.base.Optional;
import com.wordnik.swagger.annotations.ApiParam;
import java.lang.annotation.Annotation;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component(value="swaggerParameterRequiredReader")
@Order(value=-2147482648)
public class ParameterRequiredReader
implements ParameterBuilderPlugin {
    public void apply(ParameterContext context) {
        MethodParameter methodParameter = context.methodParameter();
        if (this.getAnnotatedRequired(methodParameter).isPresent()) {
            context.parameterBuilder().required(((Boolean)this.getAnnotatedRequired(methodParameter).get()).booleanValue());
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private Optional<Boolean> getAnnotatedRequired(MethodParameter methodParameter) {
        Annotation[] methodAnnotations = methodParameter.getParameterAnnotations();
        if (null != methodAnnotations) {
            for (Annotation annotation : methodAnnotations) {
                if (!(annotation instanceof ApiParam)) continue;
                return Optional.of((Object)((ApiParam)annotation).required());
            }
        }
        return Optional.absent();
    }
}

