/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.HandlerMethodReturnTypes;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class SwaggerOperationModelsProvider
implements OperationModelsProviderPlugin {
    private static final Logger log = LoggerFactory.getLogger(SwaggerOperationModelsProvider.class);
    private final TypeResolver typeResolver;

    @Autowired
    public SwaggerOperationModelsProvider(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void apply(RequestMappingContext context) {
        this.collectFromApiOperation(context);
        this.collectApiResponses(context);
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private void collectFromApiOperation(RequestMappingContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        ResolvedType returnType = HandlerMethodReturnTypes.handlerReturnType((TypeResolver)this.typeResolver, (HandlerMethod)handlerMethod);
        returnType = context.alternateFor(returnType);
        Optional optional = Annotations.findApiOperationAnnotation(handlerMethod.getMethod()).transform(Annotations.resolvedTypeFromOperation(this.typeResolver, returnType));
        if (optional.isPresent() && optional.get() != returnType) {
            context.operationModelsBuilder().addReturn((Type)optional.get());
        }
    }

    private void collectApiResponses(RequestMappingContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        Optional<ApiResponses> apiResponses = Annotations.findApiResponsesAnnotations(handlerMethod.getMethod());
        log.debug("Reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
        if (!apiResponses.isPresent()) {
            return;
        }
        for (ApiResponse response : ((ApiResponses)apiResponses.get()).value()) {
            ResolvedType modelType = context.alternateFor(this.typeResolver.resolve((Type)response.response(), new Type[0]));
            context.operationModelsBuilder().addReturn((Type)modelType);
        }
        log.debug("Finished reading parameters models for handlerMethod |{}|", (Object)handlerMethod.getMethod().getName());
    }
}

